/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositReleaseUnSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("isrevenue");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        this.deleteRevenueBills(dataEntities);
    }

    private void deleteRevenueBills(DynamicObject[] dataEntities) {
        List releaseIds = Arrays.stream(dataEntities).filter(r -> r.getBoolean("isrevenue")).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(releaseIds)) {
            return;
        }
        QFilter qFilter = new QFilter("srcreleaseid", "in", releaseIds);
        qFilter.and("revenuesort", "=", (Object)RevenueSortEnum.redeem_revenue.getValue());
        List revenueIds = QueryServiceHelper.queryPrimaryKeys((String)"cim_dptrevenue", (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
        if (EmptyUtil.isEmpty((Collection)revenueIds)) {
            return;
        }
        String releaseName = dataEntities[0].getDynamicObjectType().getName();
        String entityName = releaseName.startsWith("ifm") ? "ifm_dptrevenue" : "cim_dptrevenue";
        OperateOption option = OperateOption.create();
        option.setVariableValue("fromReleaseAudit", "true");
        TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)entityName, (Object[])revenueIds.toArray(), (OperateOption)option);
        TmcOperateServiceHelper.execOperate((String)"delete", (String)entityName, (Object[])revenueIds.toArray(), (OperateOption)option);
    }
}

