/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.BebankStatusEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class NoticeDrawConfirmService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bebankstatus");
        selector.add("submittime");
        selector.add("finbillno");
        selector.add("redeemdate");
        selector.add("amount");
        selector.add("isrevenue");
        selector.add("realrevenue");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> depositList = new ArrayList<DynamicObject>(dataEntities.length);
        Object[] depositArr = Arrays.stream(dataEntities).map(r -> r.getDynamicObject("finbillno")).map(DataEntityBase::getPkValue).toArray();
        DynamicObject[] depositBills = TmcDataServiceHelper.load((Object[])depositArr, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cim_deposit"));
        Map<Long, DynamicObject> id2Map = Arrays.stream(depositBills).collect(Collectors.toMap(r -> r.getLong("id"), r -> r));
        for (DynamicObject release : dataEntities) {
            release.set("bebankstatus", (Object)BebankStatusEnum.TS.getValue());
            release.set("submittime", (Object)new Date());
            Long depositId = release.getLong("finbillno.id");
            DynamicObject deposit = id2Map.get(depositId);
            if (!EmptyUtil.isNoEmpty((DynamicObject)deposit)) continue;
            DepositHelper.setSrcDepositBillValues((DynamicObject)deposit, (DynamicObject)release);
            depositList.add(deposit);
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
        if (EmptyUtil.isNoEmpty(depositList)) {
            SaveServiceHelper.save((DynamicObject[])depositList.toArray(new DynamicObject[0]));
        }
    }
}

