/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.dptrevenue;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class DptRevenueBatchAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("loanbillid");
        selector.add("intdetail_tag");
        selector.add("status");
        selector.add("intdetailnum");
        selector.add("intbillid");
        selector.add("intcomment");
        selector.add("intdetail_tag");
        selector.add("startdate");
        selector.add("actualinstamt");
        selector.add("revenuedate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject revBatch : dataEntities) {
            DynamicObjectCollection rows = revBatch.getDynamicObjectCollection("entry");
            Object[] depositIds = rows.stream().map(r -> r.getLong("loanbillid")).toArray();
            DynamicObject[] depositBills = TmcDataServiceHelper.load((Object[])depositIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cim_deposit"));
            Map<Long, DynamicObject> depositMap = Arrays.stream(depositBills).collect(Collectors.toMap(r -> r.getLong("id"), r -> r));
            for (DynamicObject row : rows) {
                DepositHelper.revenueAudit((DynamicObject)row, depositMap, (Date)revBatch.getDate("revenuedate"));
            }
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        OperateOption option = OperateOption.create();
        option.setVariableValue("operatekey", "audit");
        TmcOperateServiceHelper.execOperate((String)"bindbotp", (String)dataEntities[0].getDynamicObjectType().getName(), (DynamicObject[])dataEntities, (OperateOption)option);
    }
}

