/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.dptrevenue;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DptRevenueBatchSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("loanbillid");
        selector.add("intdetail_tag");
        selector.add("status");
        selector.add("intdetailnum");
        selector.add("intbillid");
        selector.add("intcomment");
        selector.add("intdetail_tag");
        selector.add("startdate");
        selector.add("actualinstamt");
        selector.add("revenuedate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject revBatch : dataEntities) {
            DynamicObjectCollection rows = revBatch.getDynamicObjectCollection("entry");
            Object[] depositIds = rows.stream().map(r -> r.getLong("loanbillid")).toArray();
            DynamicObject[] depositBills = TmcDataServiceHelper.load((Object[])depositIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cim_deposit"));
            Map<Long, DynamicObject> depositMap = Arrays.stream(depositBills).collect(Collectors.toMap(r -> r.getLong("id"), r -> r));
            ArrayList<Object> intBillIds = new ArrayList<Object>(rows.size());
            List ids = Arrays.stream(depositBills).map(Dyn -> Dyn.getPkValue().toString()).collect(Collectors.toList());
            Map LimitMap = MutexServiceHelper.batchRequest(ids, (String)"cim_deposit", (String)"submit");
            List lockIds = LimitMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
            try {
                String lockErrorBillNos = rows.stream().filter(b -> Boolean.FALSE.equals(LimitMap.get(b.getString("loanbillid")))).map(b -> b.getString("loannum")).collect(Collectors.joining(","));
                if (EmptyUtil.isNoEmpty((String)lockErrorBillNos)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u4e0b\u63a8\u6536\u76ca\u5355, \u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"DptRevenueBatchSubmitService_1", (String)"tmc-cim-business", (Object[])new Object[0]), lockErrorBillNos));
                }
                for (DynamicObject row : rows) {
                    Object intBill = DepositHelper.pushtoRevenueAndSubmit((DynamicObject)row, depositMap, (Date)revBatch.getDate("revenuedate"));
                    if (!EmptyUtil.isNoEmpty((Object)intBill)) continue;
                    intBillIds.add(intBill);
                }
            }
            catch (Exception e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u6536\u76ca\u5355\u5931\u8d25:%s\u3002", (String)"DptRevenueBatchSubmitService_2", (String)"tmc-cim-business", (Object[])new Object[0]), e.getMessage()));
            }
            finally {
                if (!lockIds.isEmpty()) {
                    MutexServiceHelper.batchRelease(lockIds, (String)"cim_deposit", (String)"submit");
                }
            }
            this.checkFail(intBillIds, revBatch, rows);
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        OperateOption option = OperateOption.create();
        option.setVariableValue("operatekey", "audit");
        TmcOperateServiceHelper.execOperate((String)"bindbotp", (String)dataEntities[0].getDynamicObjectType().getName(), (DynamicObject[])dataEntities, (OperateOption)option);
    }

    private void checkFail(List intBillIds, DynamicObject batchIntBill, DynamicObjectCollection batchInEntrys) {
        if (intBillIds.size() < batchInEntrys.size()) {
            DynamicObjectCollection batchEntrys = batchIntBill.getDynamicObjectCollection("entry");
            for (DynamicObject intEntry : batchEntrys) {
                if (!intBillIds.contains(intEntry.getLong("intbillid"))) continue;
                intEntry.set("status", (Object)"");
                intEntry.set("intcomment", (Object)"");
                intEntry.set("intdetailnum", null);
                intEntry.set("intbillid", null);
            }
            batchIntBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{batchIntBill});
            throw new KDBizException(ResManager.loadKDString((String)"\u6709\u63d0\u4ea4\u5931\u8d25\u7684\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4\uff0c\u6216\u8005\u5220\u9664\u3002", (String)"DptRevenueBatchSubmitService_0", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

