/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.dptrevenue;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class DptRevenueBatchUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("intbillid");
        selector.add("intdetailnum");
        selector.add("intcomment");
        selector.add("status");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject revenueBatch : dataEntities) {
            DynamicObjectCollection entry = revenueBatch.getDynamicObjectCollection("entry");
            List revenueIdList = entry.stream().map(r -> r.getLong("intbillid")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", revenueIdList);
            List existsIds = QueryServiceHelper.queryPrimaryKeys((String)"cim_dptrevenue", (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
            Pair batchRevenuePair = DepositHelper.getBatchRevenuePair((String)revenueBatch.getDynamicObjectType().getName(), null);
            String revenueBillName = (String)batchRevenuePair.getRight();
            for (DynamicObject row : entry) {
                long revenueId = row.getLong("intbillid");
                if (!existsIds.contains(revenueId)) {
                    row.set("intbillid", null);
                    row.set("intdetailnum", null);
                    row.set("status", (Object)"");
                    continue;
                }
                Object[] revenueIds = new Long[]{revenueId};
                if (EmptyUtil.isEmpty((Object[])revenueIds)) continue;
                OperateOption option = OperateOption.create();
                option.setVariableValue("fromBatch", "true");
                DynamicObject intBill = TmcDataServiceHelper.loadSingle((Object)revenueId, (String)"cim_dptrevenue", (String)"id,billstatus");
                String billStatus = intBill.getString("billstatus");
                if (BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                    TmcOperateServiceHelper.execOperate((String)"unaudit", (String)revenueBillName, (Object[])revenueIds, (OperateOption)option);
                }
                if (BillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
                    TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)revenueBillName, (Object[])revenueIds, (OperateOption)option);
                }
                TmcOperateServiceHelper.execOperate((String)"delete", (String)revenueBillName, (Object[])revenueIds, (OperateOption)option);
                row.set("intbillid", null);
                row.set("intdetailnum", null);
                row.set("intcomment", (Object)"");
                row.set("status", (Object)"");
            }
        }
    }
}

