/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.dptrevenue;

import java.util.Arrays;
import java.util.HashMap;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.mq.TmcMQParam;
import kd.tmc.fbp.common.mq.TmcMQTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DptRevenueCancelConfirmService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        this.modifyConfirmStatus(dataEntities);
        DepositHelper.writeBackDptRevAmt(Arrays.asList(dataEntities), (String)"substract");
        this.asyncDelRecInfo(dataEntities);
    }

    private void asyncDelRecInfo(DynamicObject[] dataEntities) {
        Object[] ids = Arrays.stream(dataEntities).filter(DepositHelper::isSettleBill).map(DataEntityBase::getPkValue).toArray();
        if (EmptyUtil.isEmpty((Object[])ids)) {
            return;
        }
        HashMap<String, Object> msgParamMap = new HashMap<String, Object>();
        QFilter filter = new QFilter("sourcebillid", "in", (Object)ids);
        DynamicObjectCollection recTransBills = QueryServiceHelper.query((String)"ifm_rectransbill", (String)"id", (QFilter[])filter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)recTransBills)) {
            Object[] recTransBillIds = recTransBills.stream().map(v -> v.get("id")).toArray();
            msgParamMap.put("ifmentityname", "ifm_rectransbill");
            msgParamMap.put("transbillids", recTransBillIds);
        }
        filter.and("billstatus", "!=", (Object)"G");
        DynamicObjectCollection recBills = QueryServiceHelper.query((String)"cas_recbill", (String)"id", (QFilter[])filter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)recBills)) {
            Object[] recBillIds = recBills.stream().map(v -> v.get("id")).toArray();
            msgParamMap.put("casentityname", "cas_recbill");
            msgParamMap.put("recpayids", recBillIds);
        }
        if (EmptyUtil.isNoEmpty(msgParamMap)) {
            TmcMQParam.build((TmcMQTypeEnum)TmcMQTypeEnum.AUTO_ASYNC_DEL_RECPAY, msgParamMap).sendMessageInDbTranscation("kd.tmc.ifm.trans");
        }
    }

    private void modifyConfirmStatus(DynamicObject[] dataEntities) {
        for (DynamicObject revenue : dataEntities) {
            revenue.set("confirmstatus", (Object)"waitconfirm");
            revenue.set("bankcheckflag", (Object)"");
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }
}

