/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.dptrevenue;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;

public class DptRevenuePlanSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("revenuedate");
        selector.add("seq");
        selector.add("revenueseq");
        selector.add("revenuestate");
        selector.add("revenuecalamount");
        selector.add("planamount");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject revPlan : dataEntities) {
            DynamicObjectCollection oriRows = revPlan.getDynamicObjectCollection("revenue_entry");
            DynamicObject[] instPlans = (DynamicObject[])oriRows.toArray((Object[])new DynamicObject[0]);
            Arrays.sort(instPlans, (o1, o2) -> {
                Date secondRowDate;
                Date firstRowDate = o1.getDate("revenuedate");
                if (firstRowDate.before(secondRowDate = o2.getDate("revenuedate"))) {
                    this.operationResult.setMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u6309\u9884\u8ba1\u6536\u76ca\u65e5\u671f\u6b63\u5e8f\u91cd\u65b0\u6392\u5e8f\u3002", (String)"DptRevenuePlanSaveService_1", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                return firstRowDate.compareTo(secondRowDate);
            });
            for (int k = 0; k < instPlans.length; ++k) {
                instPlans[k].set("seq", (Object)(k + 1));
                instPlans[k].set("revenueseq", (Object)(k + 1));
            }
        }
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("revenue_entry");
            BigDecimal planRevenueAmt = rows.stream().filter(r -> "0".equals(r.getString("revenuestate"))).map(r -> r.getBigDecimal("revenuecalamount")).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
            this.validateIntMaxValue(planRevenueAmt);
            dataEntity.set("planamount", (Object)planRevenueAmt);
        }
        SaveServiceHelper.update((DynamicObject[])dataEntities);
    }

    private void validateIntMaxValue(BigDecimal amount) {
        if (amount.compareTo(DepositHelper.RATE_MAX) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9884\u8ba1\u6536\u76ca\u503c\u8fc7\u5927\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DptRevenuePlanSaveService_2", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

