/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.deposit;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.IEBRequestDataSource;
import kd.tmc.cim.common.enums.NoticeCancelStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.webapi.ebentity.biz.deposit.DepositDetail;
import kd.tmc.fbp.webapi.ebentity.biz.paystatus.PayStatusBody;

public class NoticeToCurBookingDataSource
implements IEBRequestDataSource {
    private final DynamicObject depositApply;
    private final String type;

    public NoticeToCurBookingDataSource(DynamicObject depositBill, String type) {
        this.depositApply = depositBill;
        this.type = type;
    }

    public List<DepositDetail> getDetail() {
        ArrayList<DepositDetail> details = new ArrayList<DepositDetail>();
        DepositDetail detail = new DepositDetail();
        String depositApplyId = this.depositApply.getPkValue().toString();
        detail.setDetailSeqID(depositApplyId);
        detail.setBatchSeqID(depositApplyId);
        detail.setDetailBizNo(this.depositApply.getString("billno"));
        detail.setAccNo(this.getAcctNo());
        detail.setAmount(this.depositApply.getBigDecimal("releaseamount").setScale(6, RoundingMode.HALF_UP).toString());
        detail.setInftyp(this.depositApply.getString("prenoticeday"));
        DynamicObject account = this.depositApply.getDynamicObject("finaccountf7");
        account = TmcDataServiceHelper.loadSingleFromCache((Object)account.getPkValue(), (String)"bd_accountbanks", (String)"id,acctname,name,bank");
        detail.setAccName(account.getString("acctname"));
        DynamicObject finOrg = TmcDataServiceHelper.loadSingle((Object)account.getDynamicObject("bank").getPkValue(), (String)"bd_finorginfo", (String)"union_number,name");
        detail.setAcntBank(finOrg.getString("name"));
        detail.setAcntBankNo(finOrg.getString("union_number"));
        DynamicObject noticeDeposit = this.depositApply.getDynamicObject("deposit");
        String finAccountStr = noticeDeposit.getString("finaccount");
        if (EmptyUtil.isNoEmpty((String)finAccountStr)) {
            QFilter qFilter = new QFilter("bankaccountnumber", "=", (Object)finAccountStr);
            DynamicObject finAccount = TmcDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)"id,acctname,name,bank", (QFilter[])qFilter.toArray());
            detail.setFixedAccNo(finAccountStr);
            if (EmptyUtil.isNoEmpty((DynamicObject)finAccount)) {
                detail.setFixedAccName(finAccount.getString("acctname"));
                finOrg = TmcDataServiceHelper.loadSingleFromCache((Object)finAccount.getDynamicObject("bank").getPkValue(), (String)"bd_finorginfo", (String)"union_number,name");
                detail.setFixedAcntBank(finOrg.getString("name"));
                detail.setFixedAcntBankNo(finOrg.getString("union_number"));
            }
        }
        detail.setCurrency(this.depositApply.getDynamicObject("currency").getString("number"));
        if ("booking".equals(this.type)) {
            detail.setReqNbr(noticeDeposit.getString("reqnbr"));
        } else {
            detail.setReqNbr(this.depositApply.getString("reqnbr"));
        }
        detail.setNotifyId(this.depositApply.getString("notifyid"));
        detail.setDrawType(this.depositApply.getBoolean("isautodraw") ? "1" : "0");
        String drawDate = "";
        Date estimateDate = this.depositApply.getDate("estimatedate");
        if (EmptyUtil.isNoEmpty((Object)estimateDate)) {
            drawDate = DateUtils.formatString((Date)estimateDate, (String)"yyyyMMdd");
        }
        detail.setEndDate(drawDate);
        details.add(detail);
        return details;
    }

    @Override
    public PayStatusBody getUpdateBody() {
        return null;
    }

    @Override
    public String getAcctNo() {
        return this.depositApply.getDynamicObject("finaccountf7").getString("bankaccountnumber");
    }

    @Override
    public String getCurrency() {
        return this.depositApply.getDynamicObject("currency").getString("number");
    }

    @Override
    public String getBatchSeqId() {
        return this.depositApply.getPkValue().toString();
    }

    @Override
    public String getBatchBizNo() {
        return this.depositApply.getString("billno");
    }

    @Override
    public String getExtData() {
        if (this.depositApply.getBoolean("iscancel") && NoticeCancelStatusEnum.isFail((String)this.depositApply.getString("cancelstatus"))) {
            HashMap<String, String> extMap = new HashMap<String, String>(8);
            extMap.put("REQ", "retry");
            return SerializationUtils.toJsonString(extMap);
        }
        return null;
    }
}

