/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.deposit;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.IEBRequestDataSource;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.service.ebservice.errorcode.BankPayingErrorCode;
import kd.tmc.fbp.webapi.ebentity.biz.deposit.DepositDetail;
import kd.tmc.fbp.webapi.ebentity.biz.paystatus.PayStatusBody;
import kd.tmc.fbp.webapi.ebentity.biz.paystatus.PayStatusDetail;

public class UpdateStatusDataSource
implements IEBRequestDataSource {
    private final DynamicObject bussBill;

    public UpdateStatusDataSource(DynamicObject bussBill) {
        this.bussBill = bussBill;
    }

    @Override
    public PayStatusBody getUpdateBody() {
        PayStatusBody body = new PayStatusBody();
        body.setTotalCount(1);
        ArrayList<PayStatusDetail> details = new ArrayList<PayStatusDetail>(10);
        String updateReason = new BankPayingErrorCode().EDITBESTATUS_BYHAND().getMessage();
        PayStatusDetail detail = new PayStatusDetail();
        detail.setDetailSeqID(this.bussBill.getPkValue().toString());
        detail.setBatchSeqID(this.bussBill.getPkValue().toString());
        detail.setModifyStatus(BeBillStatusEnum.TS.getValue().equals(this.bussBill.getString("bebankstatus")) ? 12 : 13);
        detail.setUpdateReason(updateReason);
        detail.setOperator(RequestContext.get().getUserName());
        details.add(detail);
        body.setDetails(details);
        return body;
    }

    public List<DepositDetail> getDetail() {
        return null;
    }

    @Override
    public String getAcctNo() {
        String entity;
        DynamicObject account = null;
        switch (entity = this.bussBill.getDynamicObjectType().getName()) {
            case "cim_deposit": 
            case "cim_noticedeposit": {
                account = this.bussBill.getDynamicObject("settleaccount");
                break;
            }
            case "cim_release": 
            case "cim_noticerelease": {
                account = this.bussBill.getDynamicObject("finaccountf7");
                break;
            }
            case "cim_finsubscribe": {
                account = this.bussBill.getDynamicObject("settleaccount");
            }
        }
        return account != null ? account.getString("bankaccountnumber") : null;
    }

    @Override
    public String getCurrency() {
        return this.bussBill.getDynamicObject("currency").getString("number");
    }

    @Override
    public String getBatchSeqId() {
        return this.bussBill.getPkValue().toString();
    }

    @Override
    public String getBatchBizNo() {
        return this.bussBill.getString("billno");
    }

    @Override
    public String getExtData() {
        return null;
    }
}

