/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.redeem;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.IEBRequestDataSource;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.webapi.ebentity.biz.finsubscribe.FinsubscribeDetail;
import kd.tmc.fbp.webapi.ebentity.biz.paystatus.PayStatusBody;

public class RedeemDataSource
implements IEBRequestDataSource {
    private final DynamicObject redeemBill;

    public RedeemDataSource(DynamicObject redeemBill) {
        this.redeemBill = redeemBill;
    }

    public List<FinsubscribeDetail> getDetail() {
        ArrayList<FinsubscribeDetail> details = new ArrayList<FinsubscribeDetail>();
        FinsubscribeDetail detail = new FinsubscribeDetail();
        detail.setDetailBizNo(this.getBatchBizNo());
        detail.setDetailSeqID(this.redeemBill.getPkValue().toString());
        detail.setBatchSeqId(this.getBatchSeqId());
        detail.setAccNo(this.getAcctNo());
        String redeemWay = this.redeemBill.getString("redeemway");
        detail.setRedeemWay(redeemWay);
        detail.setAmount(this.getAmount());
        detail.setNumber(this.redeemBill.getString("copies"));
        detail.setPrice(this.redeemBill.getBigDecimal("iopv").toString());
        detail.setProductCode(this.redeemBill.getString("productno"));
        detail.setCurrency(this.redeemBill.getDynamicObject("currency").getString("number"));
        detail.setSecuritiesAccNo(this.redeemBill.getString("securitiesaccno"));
        detail.setReserved1(this.redeemBill.getString("contractno"));
        detail.setReserved2(this.redeemBill.getString("subcontractno"));
        detail.setCshDraFlag(this.getCshDraFlag());
        details.add(detail);
        return details;
    }

    private String getCshDraFlag() {
        String cshDraFlag = "";
        String bankCateNumber = this.getBankCateNumber();
        if ("BC-0031".equals(bankCateNumber)) {
            cshDraFlag = "N";
        } else if ("BC-0024".equals(bankCateNumber)) {
            cshDraFlag = "0";
        }
        return cshDraFlag;
    }

    private String getAmount() {
        String bankCateNumber = this.getBankCateNumber();
        if ("BC-0031".equals(bankCateNumber)) {
            return this.redeemBill.getBigDecimal("amount").setScale(0).toString();
        }
        if ("BC-0024".equals(bankCateNumber)) {
            return this.redeemBill.getBigDecimal("amount").setScale(2, 1).toString();
        }
        return this.redeemBill.getBigDecimal("amount").toString();
    }

    private String getBankCateNumber() {
        DynamicObject recAccount = this.redeemBill.getDynamicObject("recaccountf7");
        DynamicObject finAccount = TmcDataServiceHelper.loadSingleFromCache((Object)recAccount.getPkValue(), (String)"bd_accountbanks", (String)"id,acctname,name,bank");
        DynamicObject finOrg = TmcDataServiceHelper.loadSingleFromCache((Object)finAccount.getDynamicObject("bank").getPkValue(), (String)"bd_finorginfo", (String)"bank_cate");
        return finOrg.getString("bank_cate.number");
    }

    @Override
    public PayStatusBody getUpdateBody() {
        return null;
    }

    @Override
    public String getAcctNo() {
        return EmptyUtil.isEmpty((DynamicObject)this.redeemBill.getDynamicObject("recaccountf7")) ? this.redeemBill.getString("recaccount") : this.redeemBill.getDynamicObject("recaccountf7").getString("bankaccountnumber");
    }

    @Override
    public String getCurrency() {
        return this.redeemBill.getDynamicObject("currency").getString("number");
    }

    @Override
    public String getBatchSeqId() {
        return this.redeemBill.getPkValue().toString();
    }

    @Override
    public String getBatchBizNo() {
        return this.redeemBill.getString("billno");
    }

    @Override
    public String getExtData() {
        return null;
    }
}

