/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.ebservice.service.deposit;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.tmc.fbp.common.log.PayLogger;
import kd.tmc.fbp.common.log.builder.PayTraceLogBankBillBuilder;
import kd.tmc.fbp.common.log.enums.PayLogLevelEnum;
import kd.tmc.fbp.common.log.enums.PayTraceLogStepEmum;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.deposit.DepositBody;
import kd.tmc.fbp.webapi.ebentity.biz.deposit.DepositDetail;

public abstract class AbstractDepositService
implements IEBService<SyncStatusResult> {
    private SyncStatusResult result;
    private static final PayLogger traceLogger = PayLogger.create(AbstractDepositService.class);

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void handleResultBody(String resultBody) {
        traceLogger.logBatch(new PayTraceLogBankBillBuilder(Collections.singletonList(this.getDepositBill()), PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.PAY.getValue(), ResManager.loadKDString((String)"\u5904\u7406\u94f6\u4f01\u54cd\u5e94\u62a5\u6587", (String)"AbstractDepositService_0", (String)"tmc-cim-business", (Object[])new Object[0]), null, null).build());
        DepositBody depositBody = (DepositBody)JSON.parseObject((String)resultBody, DepositBody.class);
        List details = depositBody.getDetails();
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.result = this.handleSuccessResult(details);
                traceLogger.logBatch(new PayTraceLogBankBillBuilder(Collections.singletonList(this.getDepositBill()), PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.PAY.getValue(), ResManager.loadKDString((String)"\u5904\u7406\u94f6\u4f01\u54cd\u5e94\u62a5\u6587\u7ed3\u679c", (String)"AbstractDepositService_1", (String)"tmc-cim-business", (Object[])new Object[0]), null, null).build());
            }
            catch (Exception e) {
                tx.markRollback();
                traceLogger.logBatch(new PayTraceLogBankBillBuilder(Collections.singletonList(this.getDepositBill()), PayLogLevelEnum.ERROR.getValue(), PayTraceLogStepEmum.PAY.getValue(), ResManager.loadKDString((String)"\u5904\u7406\u94f6\u4f01\u54cd\u5e94\u62a5\u6587\u4ea7\u751f\u5f02\u5e38", (String)"AbstractDepositService_2", (String)"tmc-cim-business", (Object[])new Object[0]), null, e).build());
                throw e;
            }
        }
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        traceLogger.logBatch(new PayTraceLogBankBillBuilder(Collections.singletonList(this.getDepositBill()), PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.PAY.getValue(), ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38\u4fe1\u606f", (String)"AbstractDepositService_3", (String)"tmc-cim-business", (Object[])new Object[0]), null, e).build());
        this.result = new SyncStatusResult();
        this.result.setStatusCode(EBResultStatusCode.ERROR);
        this.result.setErrMsg(errMsg);
        this.result.setBankBillId(this.getDepositBillId());
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.handleEBException();
            }
            catch (Exception ee) {
                tx.markRollback();
                traceLogger.logBatch(new PayTraceLogBankBillBuilder(Collections.singletonList(this.getDepositBill()), PayLogLevelEnum.ERROR.getValue(), PayTraceLogStepEmum.PAY.getValue(), ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38\u65f6\u4ea7\u751f\u5f02\u5e38", (String)"AbstractDepositService_4", (String)"tmc-cim-business", (Object[])new Object[0]), null, ee).build());
                throw ee;
            }
        }
    }

    public void rollback(String errMsg, Exception e) {
        traceLogger.logBatch(new PayTraceLogBankBillBuilder(Collections.singletonList(this.getDepositBill()), PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.PAY.getValue(), ResManager.loadKDString((String)"\u5904\u7406\u56de\u6eda\u4fe1\u606f", (String)"AbstractDepositService_5", (String)"tmc-cim-business", (Object[])new Object[0]), errMsg, e).build());
        this.result = new SyncStatusResult();
        this.result.setStatusCode(EBResultStatusCode.ROLLBACK);
        this.result.setErrMsg(errMsg);
        this.result.setBankBillId(this.getDepositBillId());
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.handleRollbackResult();
            }
            catch (Exception ee) {
                tx.markRollback();
                traceLogger.logBatch(new PayTraceLogBankBillBuilder(Collections.singletonList(this.getDepositBill()), PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.PAY.getValue(), ResManager.loadKDString((String)"\u5904\u7406\u56de\u6eda\u4fe1\u606f\u65f6\u4ea7\u751f\u5f02\u5e38", (String)"AbstractDepositService_6", (String)"tmc-cim-business", (Object[])new Object[0]), errMsg, ee).build());
                throw ee;
            }
        }
    }

    public SyncStatusResult getEBResult() {
        return this.result;
    }

    protected abstract SyncStatusResult handleSuccessResult(List<DepositDetail> var1);

    protected abstract void handleEBException();

    protected abstract void handleRollbackResult();

    protected abstract Long getDepositBillId();

    protected abstract DynamicObject getDepositBill();
}

