/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.ebservice.service.deposit;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.bussiness.opservice.ebservice.request.DepositRequestBuilder;
import kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.deposit.CurrentToFixedDataSource;
import kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.deposit.CurrentToNoticeDataSource;
import kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.deposit.FixedToCurrentDataSource;
import kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.deposit.NoticeToCurBookingDataSource;
import kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.deposit.WithDrawFromNAccDataSource;
import kd.tmc.cim.bussiness.opservice.ebservice.service.deposit.AbstractDepositService;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.webapi.ebentity.biz.deposit.DepositDetail;

public class CurrentAndFixedService
extends AbstractDepositService {
    private final DynamicObject depositBill;

    public CurrentAndFixedService(DynamicObject depositBill) {
        this.depositBill = depositBill;
    }

    @Override
    protected DynamicObject getDepositBill() {
        return this.depositBill;
    }

    @Override
    protected void handleRollbackResult() {
        this.depositBill.set("bebankstatus", null);
        this.depositBill.set("submittime", null);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.depositBill});
    }

    @Override
    protected Long getDepositBillId() {
        return (Long)this.depositBill.getPkValue();
    }

    @Override
    protected SyncStatusResult handleSuccessResult(List<DepositDetail> details) {
        SyncStatusResult syncInfo = new SyncStatusResult();
        DepositHelper.dealResponseResult(details, (DynamicObject)this.depositBill, (String)this.getEntityName());
        syncInfo.setBatchSeqId(details.get(0).getBatchSeqID());
        syncInfo.setStatusCode(EBResultStatusCode.SUCCESS);
        syncInfo.setErrMsg(null);
        syncInfo.setBankBillId((Long)this.depositBill.getPkValue());
        return syncInfo;
    }

    @Override
    protected void handleEBException() {
        this.depositBill.set("bebankstatus", (Object)BeBillStatusEnum.NC.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.depositBill});
    }

    public IEBRequestBuilder getRequestBuilder() {
        if ("cim_deposit".equals(this.getEntityName())) {
            CurrentToFixedDataSource dataSource = new CurrentToFixedDataSource(this.depositBill);
            return new DepositRequestBuilder("currentAndFixed", "currentToFixed", dataSource);
        }
        if ("cim_release".equals(this.getEntityName())) {
            FixedToCurrentDataSource dataSource = new FixedToCurrentDataSource(this.depositBill);
            return new DepositRequestBuilder("currentAndFixed", "fixedToCurrent", dataSource);
        }
        if ("cim_noticedeposit".equals(this.getEntityName())) {
            CurrentToNoticeDataSource dataSource = new CurrentToNoticeDataSource(this.depositBill);
            return new DepositRequestBuilder("currentAndFixed", "currentToNotice", dataSource);
        }
        if ("cim_noticerelease".equals(this.getEntityName())) {
            WithDrawFromNAccDataSource dataSource = new WithDrawFromNAccDataSource(this.depositBill);
            return new DepositRequestBuilder("withdrawFromNAcc", "withdrawFromNAcc", dataSource);
        }
        if ("cim_deposit_apply".equals(this.getEntityName())) {
            NoticeToCurBookingDataSource dataSource = new NoticeToCurBookingDataSource(this.depositBill, "booking");
            return new DepositRequestBuilder("currentAndFixed", "noticeToCurrent", dataSource);
        }
        return null;
    }

    public String getEntityName() {
        return this.depositBill.getDataEntityType().getName();
    }

    public BankLogInfo getBankLogInfo() {
        BankLogInfo logInfo = new BankLogInfo();
        logInfo.setSourceId(Long.valueOf(this.depositBill.getLong("id")));
        logInfo.setBillNo(this.depositBill.getString("billno"));
        logInfo.setEntityName(this.getEntityName());
        logInfo.setOrgid((Long)this.depositBill.getDynamicObject("org").getPkValue());
        return logInfo;
    }

    public Long getBankCateId() {
        return DepositHelper.getBankCateId((DynamicObject)this.depositBill, (String)this.getEntityName());
    }
}

