/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.ebservice.service.deposit;

import com.alibaba.fastjson.JSON;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.bussiness.opservice.ebservice.request.QueryDepositRequestBuilder;
import kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.deposit.CurrentAndFixedQueryDataSource;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.ebservice.data.EBResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.deposit.DepositBody;

public class DepositQueryService
implements IEBService<EBResult> {
    private EBResult ebResult;
    private final DynamicObject depositBill;

    public DepositQueryService(DynamicObject depositBill) {
        this.depositBill = depositBill;
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void handleResultBody(String resultBody) {
        DepositBody result = (DepositBody)JSON.parseObject((String)resultBody, DepositBody.class);
        List details = result.getDetails();
        if (details == null || details.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65\u72b6\u6001\u65f6\uff0c\u94f6\u4f01\u8fd4\u56de\u7684\u660e\u7ec6\u4e3a\u7a7a\u3002\u8bf7\u67e5\u770b\u540c\u6b65\u65e5\u5fd7\u8be6\u60c5\u3002", (String)"DepositQueryService_0", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
        DepositHelper.dealResponseResult((List)details, (DynamicObject)this.depositBill, (String)this.getEntityName());
        this.ebResult = new EBResult();
        this.ebResult.setStatusCode(EBResultStatusCode.SUCCESS);
    }

    private Long getBankBillId() {
        return (Long)this.depositBill.getPkValue();
    }

    public IEBRequestBuilder getRequestBuilder() {
        String subBizType = null;
        switch (this.getEntityName()) {
            case "cim_deposit": {
                subBizType = "queryCurrentToFixed";
                break;
            }
            case "cim_release": {
                subBizType = "queryFixedToCurrent";
                break;
            }
            case "cim_noticedeposit": {
                subBizType = "queryCurrentToNotice";
                break;
            }
            case "cim_noticerelease": {
                subBizType = "queryNoticeTocurrent";
                break;
            }
            case "cim_deposit_apply": {
                subBizType = "queryNoticeTocurrent";
            }
        }
        CurrentAndFixedQueryDataSource dataSource = new CurrentAndFixedQueryDataSource(this.depositBill);
        return new QueryDepositRequestBuilder(subBizType, dataSource);
    }

    public String getEntityName() {
        return this.depositBill.getDynamicObjectType().getName();
    }

    public BankLogInfo getBankLogInfo() {
        BankLogInfo logInfo = new BankLogInfo();
        logInfo.setSourceId(Long.valueOf(this.depositBill.getLong("id")));
        logInfo.setBillNo(this.depositBill.getString("billno"));
        logInfo.setEntityName(this.getEntityName());
        logInfo.setOrgid((Long)this.depositBill.getDynamicObject("org").getPkValue());
        return logInfo;
    }

    public void rollback(String errMsg, Exception e) {
        this.ebResult = new EBResult();
        this.ebResult.setStatusCode(EBResultStatusCode.ROLLBACK);
        this.ebResult.setErrMsg(errMsg);
        this.ebResult.setBankBillId(this.getBankBillId());
    }

    public void handleEBException(String body, String errMsg, Exception e) {
        this.ebResult = new EBResult();
        this.ebResult.setStatusCode(EBResultStatusCode.ERROR);
        this.ebResult.setErrMsg(errMsg);
        this.ebResult.setBankBillId(this.getBankBillId());
        if (e instanceof EBBizNCException) {
            this.ebResult.setErrCode(((EBBizNCException)e).getErrorCode());
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                DepositBody result = (DepositBody)JSON.parseObject((String)body, DepositBody.class);
                this.handleException(result, e);
            }
            catch (Exception ee) {
                tx.markRollback();
                throw ee;
            }
        }
    }

    protected void handleException(DepositBody result, Exception e) {
        this.depositBill.set("bebankstatus", (Object)BeBillStatusEnum.NC.getValue());
        TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{this.depositBill});
    }

    public EBResult getEBResult() {
        return this.ebResult;
    }

    public Long getBankCateId() {
        return DepositHelper.getBankCateId((DynamicObject)this.depositBill, (String)this.getEntityName());
    }
}

