/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.ebservice.service.deposit;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.bussiness.opservice.ebservice.request.CancelBookingRequestBuilder;
import kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.deposit.NoticeToCurBookingDataSource;
import kd.tmc.cim.bussiness.opservice.ebservice.service.deposit.AbstractDepositService;
import kd.tmc.cim.common.enums.NoticeCancelStatusEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.webapi.ebentity.biz.deposit.DepositDetail;

public class NoticeCancelBookingService
extends AbstractDepositService {
    private final DynamicObject depositBill;

    public NoticeCancelBookingService(DynamicObject depositBill) {
        this.depositBill = depositBill;
    }

    @Override
    protected DynamicObject getDepositBill() {
        return this.depositBill;
    }

    @Override
    protected void handleRollbackResult() {
        this.depositBill.set("cancelstatus", null);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.depositBill});
    }

    @Override
    protected Long getDepositBillId() {
        return (Long)this.depositBill.getPkValue();
    }

    @Override
    protected SyncStatusResult handleSuccessResult(List<DepositDetail> details) {
        SyncStatusResult syncInfo = new SyncStatusResult();
        this.writeBackApply(details);
        syncInfo.setBatchSeqId(details.get(0).getBatchSeqID());
        syncInfo.setStatusCode(EBResultStatusCode.SUCCESS);
        syncInfo.setErrMsg(null);
        syncInfo.setBankBillId((Long)this.depositBill.getPkValue());
        return syncInfo;
    }

    @Override
    protected void handleEBException() {
        this.depositBill.set("cancelstatus", (Object)NoticeCancelStatusEnum.UNKNOWN.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.depositBill});
    }

    public IEBRequestBuilder getRequestBuilder() {
        NoticeToCurBookingDataSource dataSource = new NoticeToCurBookingDataSource(this.depositBill, "cancelbooking");
        return new CancelBookingRequestBuilder("cancelNotification", "cancelNotification", dataSource);
    }

    public String getEntityName() {
        return this.depositBill.getDataEntityType().getName();
    }

    public BankLogInfo getBankLogInfo() {
        BankLogInfo logInfo = new BankLogInfo();
        logInfo.setSourceId(Long.valueOf(this.depositBill.getLong("id")));
        logInfo.setBillNo(this.depositBill.getString("billno"));
        logInfo.setEntityName(this.getEntityName());
        logInfo.setOrgid((Long)this.depositBill.getDynamicObject("org").getPkValue());
        return logInfo;
    }

    public Long getBankCateId() {
        return DepositHelper.getBankCateId((DynamicObject)this.depositBill, (String)this.getEntityName());
    }

    private void writeBackApply(List<DepositDetail> details) {
        DepositDetail detail = details.get(0);
        String status = detail.getStatus();
        this.depositBill.set("iscancel", (Object)Boolean.TRUE);
        this.depositBill.set("cancelstatus", (Object)status);
        this.depositBill.set("returnmsg", (Object)detail.getStatusMsg());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.depositBill});
        if (NoticeCancelStatusEnum.isSuccess((String)status)) {
            Object[] noticeReleaseIds = TmcBotpHelper.getTargetBillIds((String)"cim_deposit_apply", (Object)this.depositBill.getPkValue(), (String)"cim_noticerelease");
            OperateOption option = OperateOption.create();
            option.setVariableValue("fromApplyCancel", "true");
            OperationResult unauditResult = TmcOperateServiceHelper.execOperate((String)"unaudit", (String)"cim_noticerelease", (Object[])noticeReleaseIds, (OperateOption)option);
            if (EmptyUtil.isNoEmpty((Object)unauditResult) && unauditResult.isSuccess()) {
                TmcOperateServiceHelper.execOperate((String)"delete", (String)"cim_noticerelease", (Object[])noticeReleaseIds, (OperateOption)option);
            }
        }
    }
}

