/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.ebservice.service.finsubscribe;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.bussiness.opservice.ebservice.request.FinSubscribeRequestBuilder;
import kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.finsubscribe.FinSubscribeDataSource;
import kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.redeem.RedeemDataSource;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.helper.FinSubscribeHelper;
import kd.tmc.cim.common.helper.RedeemBillHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.log.PayLogger;
import kd.tmc.fbp.common.log.builder.PayTraceLogBankBillBuilder;
import kd.tmc.fbp.common.log.enums.PayLogLevelEnum;
import kd.tmc.fbp.common.log.enums.PayTraceLogStepEmum;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.finsubscribe.FinsubscribeBody;
import kd.tmc.fbp.webapi.ebentity.biz.finsubscribe.FinsubscribeDetail;

public class FinSubscribeOnlineService
implements IEBService<SyncStatusResult> {
    private final DynamicObject finSubscribeBill;
    private SyncStatusResult result;
    private static final PayLogger traceLogger = PayLogger.create(FinSubscribeOnlineService.class);

    public FinSubscribeOnlineService(DynamicObject finSubscribeBill) {
        this.finSubscribeBill = finSubscribeBill;
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
        traceLogger.logBatch(new PayTraceLogBankBillBuilder(Collections.singletonList(this.getFinSubscribeBill()), PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.PAY.getValue(), ResManager.loadKDString((String)"\u5904\u7406\u56de\u6eda\u4fe1\u606f", (String)"FinSubscribeOnlineService_0", (String)"tmc-cim-business", (Object[])new Object[0]), errMsg, e).build());
        this.result = new SyncStatusResult();
        this.result.setStatusCode(EBResultStatusCode.ROLLBACK);
        this.result.setErrMsg(errMsg);
        this.result.setBankBillId(this.getFinsubscribeBillId());
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.finSubscribeBill.set("bebankstatus", null);
                this.finSubscribeBill.set("submittime", null);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.finSubscribeBill});
            }
            catch (Exception ee) {
                tx.markRollback();
                traceLogger.logBatch(new PayTraceLogBankBillBuilder(Collections.singletonList(this.getFinSubscribeBill()), PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.PAY.getValue(), ResManager.loadKDString((String)"\u5904\u7406\u56de\u6eda\u4fe1\u606f\u65f6\u4ea7\u751f\u5f02\u5e38", (String)"FinSubscribeOnlineService_1", (String)"tmc-cim-business", (Object[])new Object[0]), errMsg, ee).build());
                throw ee;
            }
        }
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        traceLogger.logBatch(new PayTraceLogBankBillBuilder(Collections.singletonList(this.getFinSubscribeBill()), PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.PAY.getValue(), ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38\u4fe1\u606f", (String)"FinSubscribeOnlineService_2", (String)"tmc-cim-business", (Object[])new Object[0]), null, e).build());
        this.result = new SyncStatusResult();
        this.result.setStatusCode(EBResultStatusCode.ERROR);
        this.result.setErrMsg(errMsg);
        this.result.setBankBillId(this.getFinsubscribeBillId());
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.finSubscribeBill.set("bebankstatus", (Object)BeBillStatusEnum.NC.getValue());
                if ("cim_finsubscribe".equals(this.getEntityName())) {
                    this.finSubscribeBill.set("finservicestatus", (Object)FinServiceStatusEnum.subscribe_ing.getValue());
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.finSubscribeBill});
            }
            catch (Exception ee) {
                tx.markRollback();
                traceLogger.logBatch(new PayTraceLogBankBillBuilder(Collections.singletonList(this.getFinSubscribeBill()), PayLogLevelEnum.ERROR.getValue(), PayTraceLogStepEmum.PAY.getValue(), ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38\u65f6\u4ea7\u751f\u5f02\u5e38", (String)"FinSubscribeOnlineService_3", (String)"tmc-cim-business", (Object[])new Object[0]), resultBody, ee).build());
                throw ee;
            }
        }
    }

    public void handleResultBody(String resultBody) {
        traceLogger.logBatch(new PayTraceLogBankBillBuilder(Collections.singletonList(this.getFinSubscribeBill()), PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.PAY.getValue(), ResManager.loadKDString((String)"\u5904\u7406\u94f6\u4f01\u54cd\u5e94\u62a5\u6587", (String)"FinSubscribeOnlineService_4", (String)"tmc-cim-business", (Object[])new Object[0]), null, null).build());
        FinsubscribeBody finsubscribeBody = (FinsubscribeBody)JSON.parseObject((String)resultBody, FinsubscribeBody.class);
        List details = finsubscribeBody.getDetails();
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.result = this.handleSuccessResult(details);
                traceLogger.logBatch(new PayTraceLogBankBillBuilder(Collections.singletonList(this.getFinSubscribeBill()), PayLogLevelEnum.INFO.getValue(), PayTraceLogStepEmum.PAY.getValue(), ResManager.loadKDString((String)"\u5904\u7406\u94f6\u4f01\u54cd\u5e94\u62a5\u6587\u7ed3\u679c", (String)"FinSubscribeOnlineService_5", (String)"tmc-cim-business", (Object[])new Object[0]), null, null).build());
            }
            catch (Exception e) {
                tx.markRollback();
                traceLogger.logBatch(new PayTraceLogBankBillBuilder(Collections.singletonList(this.getFinSubscribeBill()), PayLogLevelEnum.ERROR.getValue(), PayTraceLogStepEmum.PAY.getValue(), ResManager.loadKDString((String)"\u5904\u7406\u94f6\u4f01\u54cd\u5e94\u62a5\u6587\u4ea7\u751f\u5f02\u5e38", (String)"FinSubscribeOnlineService_6", (String)"tmc-cim-business", (Object[])new Object[0]), null, e).build());
                throw e;
            }
        }
    }

    public IEBRequestBuilder getRequestBuilder() {
        if ("cim_finsubscribe".equals(this.getEntityName())) {
            FinSubscribeDataSource dataSource = new FinSubscribeDataSource(this.finSubscribeBill);
            return new FinSubscribeRequestBuilder("buyFinancing", dataSource);
        }
        if ("cim_redeem".equals(this.getEntityName())) {
            RedeemDataSource dataSource = new RedeemDataSource(this.finSubscribeBill);
            return new FinSubscribeRequestBuilder("redeemFinancing", dataSource);
        }
        return null;
    }

    public String getEntityName() {
        return this.finSubscribeBill.getDataEntityType().getName();
    }

    public BankLogInfo getBankLogInfo() {
        BankLogInfo logInfo = new BankLogInfo();
        logInfo.setSourceId(Long.valueOf(this.finSubscribeBill.getLong("id")));
        logInfo.setBillNo(this.finSubscribeBill.getString("billno"));
        logInfo.setEntityName(this.getEntityName());
        logInfo.setOrgid((Long)this.finSubscribeBill.getDynamicObject("org").getPkValue());
        return logInfo;
    }

    public SyncStatusResult getEBResult() {
        return this.result;
    }

    public Long getBankCateId() {
        return FinSubscribeHelper.getBankCateId((DynamicObject)this.finSubscribeBill, (String)this.getEntityName());
    }

    private DynamicObject getFinSubscribeBill() {
        return this.finSubscribeBill;
    }

    private SyncStatusResult handleSuccessResult(List<FinsubscribeDetail> details) {
        SyncStatusResult syncInfo = new SyncStatusResult();
        if ("cim_finsubscribe".equals(this.getEntityName())) {
            FinSubscribeHelper.dealResponseResult(details, (DynamicObject)this.finSubscribeBill, (boolean)false);
        } else if ("cim_redeem".equals(this.getEntityName())) {
            RedeemBillHelper.dealResponseResult(details, (DynamicObject)this.finSubscribeBill, (boolean)false);
        }
        syncInfo.setBatchSeqId(details.get(0).getBatchSeqId());
        syncInfo.setStatusCode(EBResultStatusCode.SUCCESS);
        syncInfo.setErrMsg(null);
        syncInfo.setBankBillId((Long)this.finSubscribeBill.getPkValue());
        return syncInfo;
    }

    protected Long getFinsubscribeBillId() {
        return (Long)this.finSubscribeBill.getPkValue();
    }
}

