/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.ebservice.service.finsubscribe;

import com.alibaba.fastjson.JSON;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.bussiness.opservice.ebservice.request.QueryFinSubscribeRequestBuilder;
import kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.finsubscribe.FinSubscribeQueryDataSource;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.helper.FinSubscribeHelper;
import kd.tmc.cim.common.helper.RedeemBillHelper;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.service.ebservice.data.EBResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.exception.EBBizNCException;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.finsubscribe.FinsubscribeBody;

public class FinSubscribeQueryService
implements IEBService<EBResult> {
    private EBResult ebResult;
    private final DynamicObject finSubscribeBill;

    public FinSubscribeQueryService(DynamicObject finSubscribeBill) {
        this.finSubscribeBill = finSubscribeBill;
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void handleResultBody(String resultBody) {
        FinsubscribeBody result = (FinsubscribeBody)JSON.parseObject((String)resultBody, FinsubscribeBody.class);
        List details = result.getDetails();
        if (details == null || details.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65\u72b6\u6001\u65f6\uff0c\u94f6\u4f01\u8fd4\u56de\u7684\u660e\u7ec6\u4e3a\u7a7a\u3002\u8bf7\u67e5\u770b\u540c\u6b65\u65e5\u5fd7\u8be6\u60c5\u3002", (String)"DepositQueryService_0", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
        if ("cim_finsubscribe".equals(this.getEntityName())) {
            FinSubscribeHelper.dealResponseResult((List)details, (DynamicObject)this.finSubscribeBill, (boolean)false);
        } else if ("cim_redeem".equals(this.getEntityName())) {
            RedeemBillHelper.dealResponseResult((List)details, (DynamicObject)this.finSubscribeBill, (boolean)false);
        }
        this.ebResult = new EBResult();
        this.ebResult.setStatusCode(EBResultStatusCode.SUCCESS);
    }

    private Long getBankBillId() {
        return (Long)this.finSubscribeBill.getPkValue();
    }

    public IEBRequestBuilder getRequestBuilder() {
        String subBizType = null;
        switch (this.getEntityName()) {
            case "cim_finsubscribe": {
                subBizType = "queryBuyFinancing";
                break;
            }
            case "cim_redeem": {
                subBizType = "queryRedeemFinancing";
            }
        }
        FinSubscribeQueryDataSource dataSource = new FinSubscribeQueryDataSource(this.finSubscribeBill);
        return new QueryFinSubscribeRequestBuilder(subBizType, dataSource, this.finSubscribeBill);
    }

    public String getEntityName() {
        return this.finSubscribeBill.getDynamicObjectType().getName();
    }

    public BankLogInfo getBankLogInfo() {
        BankLogInfo logInfo = new BankLogInfo();
        logInfo.setSourceId(Long.valueOf(this.finSubscribeBill.getLong("id")));
        logInfo.setBillNo(this.finSubscribeBill.getString("billno"));
        logInfo.setEntityName(this.getEntityName());
        logInfo.setOrgid((Long)this.finSubscribeBill.getDynamicObject("org").getPkValue());
        return logInfo;
    }

    public void rollback(String errMsg, Exception e) {
        this.ebResult = new EBResult();
        this.ebResult.setStatusCode(EBResultStatusCode.ROLLBACK);
        this.ebResult.setErrMsg(errMsg);
        this.ebResult.setBankBillId(this.getBankBillId());
    }

    public void handleEBException(String body, String errMsg, Exception e) {
        this.ebResult = new EBResult();
        this.ebResult.setStatusCode(EBResultStatusCode.ERROR);
        this.ebResult.setErrMsg(errMsg);
        this.ebResult.setBankBillId(this.getBankBillId());
        if (e instanceof EBBizNCException) {
            this.ebResult.setErrCode(((EBBizNCException)e).getErrorCode());
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.handleException(errMsg);
            }
            catch (Exception ee) {
                tx.markRollback();
                throw ee;
            }
        }
    }

    protected void handleException(String errMsg) {
        if ("cim_finsubscribe".equals(this.getEntityName())) {
            this.finSubscribeBill.set("finservicestatus", (Object)FinServiceStatusEnum.subscribe_ing.getValue());
        }
        this.finSubscribeBill.set("bebankstatus", (Object)BeBillStatusEnum.NC.getValue());
        this.finSubscribeBill.set("returnmsg", (Object)errMsg);
        TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{this.finSubscribeBill});
    }

    public EBResult getEBResult() {
        return this.ebResult;
    }

    public Long getBankCateId() {
        return FinSubscribeHelper.getBankCateId((DynamicObject)this.finSubscribeBill, (String)this.getEntityName());
    }
}

