/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.ebservice.service.supermarket;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.cim.bussiness.opservice.ebservice.service.supermarket.PrdCardService;
import kd.tmc.cim.common.helper.SuperMarketHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class AbcPrdCardServiceImpl
implements PrdCardService {
    @Override
    public void execute(JSONObject row, Pair<DynamicObject, DynamicObject> marketPair, Map<String, Long> currencyMap) {
        DynamicObject marketBill = (DynamicObject)marketPair.getLeft();
        DynamicObject prdCardBill = (DynamicObject)marketPair.getRight();
        prdCardBill.set("number", (Object)row.getString("productCode"));
        SuperMarketHelper.setValueWhenNotNull((DynamicObject)prdCardBill, (String)"currency", (Object)currencyMap.get(row.getString("currency")));
        SuperMarketHelper.setValueWhenNotNull((DynamicObject)prdCardBill, (String)"abc_applyprice", (Object)row.getBigDecimal("buyPrice"));
        SuperMarketHelper.setValueWhenNotNull((DynamicObject)prdCardBill, (String)"abc_redeemmaxamt", (Object)row.getBigDecimal("redeemMax"));
        SuperMarketHelper.setValueWhenNotNull((DynamicObject)prdCardBill, (String)"abc_redeemminamt", (Object)row.getBigDecimal("redeemMin"));
        SuperMarketHelper.setValueWhenNotNull((DynamicObject)prdCardBill, (String)"abc_risklevel", (Object)row.getString("riskLev"));
        String bankFields = row.getString("bankFields");
        List fieldList = JSONObject.parseArray((String)bankFields, JSONObject.class);
        HashMap<String, String> timestampMap = new HashMap<String, String>(8);
        for (int j = 0; j < fieldList.size(); ++j) {
            JSONObject r = (JSONObject)fieldList.get(j);
            String bankField = r.getString("key");
            String cardField = SuperMarketHelper.turnBankFieldToCard((String)bankField, (String)"PrdDueDes,StartDate,EndDate,BuyStepAmt,SubscribStatus,PurchaseStatus,RedeemStatus,PrdOrg,PrdSaleSta,PrdBrand,SaleFrom,PurchaseAmt,StartAmt,StepAmt,TipAmt,PurchaseStepAmt,MktDate,UnitValue,TotValue,UnitBons,PftValue,DaysValue,YearValue,TotYearValue,CstnValue,TotCstnValue,MktBase", (String)"abc_term,abc_startdate,abc_untilldate,abc_redeembyamt,abc_applystat,abc_finsubstat,abc_redeemstat,abc_finorg,abc_bizstat,abc_prdname,abc_sellchannel,abc_applyrefamt,abc_compminamt,abc_compbyamt,abc_compmaxamt,abc_finsubminamt,abc_marketdate,abc_iopv,abc_totaliopv,abc_totalbonus,abc_perrevenue,abc_sevenrate,abc_yearrate,abc_yeartotalrate,abc_buildrate,abc_buildtotalrate,abc_achibase");
            if (EmptyUtil.isNoEmpty((String)cardField) && cardField.startsWith("abc_")) {
                Object value = r.get((Object)"value");
                if (SuperMarketHelper.isTurnToDate((String)bankField, (String)"StartDate,EndDate,MktDate") && EmptyUtil.isNoEmpty((Object)value)) {
                    value = SuperMarketHelper.getFormatDate((String)value.toString());
                }
                SuperMarketHelper.setValueWhenNotNull((DynamicObject)prdCardBill, (String)cardField, (Object)value);
                continue;
            }
            if (StringUtils.equals((CharSequence)"ExpectDes", (CharSequence)bankField)) {
                String planRevenue = r.getString("value");
                if (!EmptyUtil.isNoEmpty((String)planRevenue)) continue;
                planRevenue = planRevenue.replaceAll("%", "");
                SuperMarketHelper.setValueWhenNotNull((DynamicObject)marketBill, (String)"planrevenue", (Object)planRevenue);
                continue;
            }
            if (StringUtils.equals((CharSequence)"ProfitType", (CharSequence)bankField)) {
                String string = r.getString("value");
                continue;
            }
            if (!SuperMarketHelper.ABC_TIMESTAMP_LIST.contains(bankField)) continue;
            timestampMap.put(bankField, r.getString("value"));
        }
        this.setAbcTimestampColumn(prdCardBill, "abc_finstartdate", timestampMap, "SStartDate", "SStartTime");
        this.setAbcTimestampColumn(prdCardBill, "abc_finenddate", timestampMap, "SEndDate", "SEndTime");
        this.setAbcTimestampColumn(prdCardBill, "abc_bonstartdate", timestampMap, "MStartDate", "MStartTime");
        this.setAbcTimestampColumn(prdCardBill, "abc_bonenddate", timestampMap, "MEndDate", "MStopTime");
    }

    private void setAbcTimestampColumn(DynamicObject prdCardBill, String cardField, Map<String, String> timestampMap, String datePart, String timePart) {
        String dateStr = timestampMap.get(datePart);
        if (EmptyUtil.isEmpty((String)dateStr)) {
            return;
        }
        Date date = DateUtils.stringToDate((String)dateStr, (String)"yyyyMMdd");
        String timeStr = Optional.ofNullable(timestampMap.get(timePart)).filter(r -> EmptyUtil.isNoEmpty((String)r) && r.length() >= 6).map(r -> r.substring(0, 2) + ':' + r.substring(2, 4) + ':' + r.substring(4)).orElse("00:00:00");
        Date formatDate = SuperMarketHelper.getFormatDate((String)(DateUtils.formatString((Date)date, (String)"yyyy-MM-dd") + ' ' + timeStr), (String)"yyyy-MM-dd HH:mm:ss");
        SuperMarketHelper.setValueWhenNotNull((DynamicObject)prdCardBill, (String)cardField, (Object)formatDate);
    }
}

