/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.ebservice.service.supermarket;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.cim.bussiness.opservice.ebservice.request.PullInterfaceRequestBuilder;
import kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.supermarket.PullInterfaceDataSource;
import kd.tmc.fbp.service.ebservice.data.EBGetLoginListResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.errorcode.EBBizErrorCode;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import kd.tmc.fbp.webapi.ebentity.biz.listbanklogin.LoginDetail;

public class PullInterfaceService
implements IEBService<EBGetLoginListResult> {
    private DynamicObject bankCate;
    private EBGetLoginListResult result;

    public PullInterfaceService(DynamicObject bankCate) {
        this.bankCate = bankCate;
        this.result = new EBGetLoginListResult();
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
        this.result.setStatusCode(EBResultStatusCode.ROLLBACK);
        this.result.setErrMsg(errMsg);
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        this.result.setStatusCode(EBResultStatusCode.ERROR);
        this.result.setErrMsg(errMsg);
    }

    public void handleResultBody(String resultBody) {
        JSONObject bodyObj = JSON.parseObject((String)resultBody);
        String detailsStr = JSONObject.toJSONString((Object)bodyObj.get((Object)"details"));
        List details = (List)JSON.parseObject((String)detailsStr, (TypeReference)new TypeReference<List<LoginDetail>>(){}, (Feature[])new Feature[0]);
        if (CollectionUtils.isEmpty((Collection)details)) {
            this.result.setStatusCode(EBResultStatusCode.ERROR);
            this.result.setErrMsg(new EBBizErrorCode().ERROR_BEBANKINTER().getMessage());
            return;
        }
        String keyword = this.bankCate.getString("name");
        HashMap<String, String> loginMap = new HashMap<String, String>();
        for (LoginDetail detail : details) {
            if (keyword == null || !detail.getBankName().contains(keyword.trim())) continue;
            loginMap.put(detail.getLoginID(), detail.getBankVersionName());
        }
        if (loginMap.size() == 0) {
            for (LoginDetail detail : details) {
                loginMap.put(detail.getLoginID(), detail.getBankVersionName());
            }
        }
        this.result.setStatusCode(EBResultStatusCode.SUCCESS);
        this.result.setLoginMap(loginMap);
    }

    public IEBRequestBuilder getRequestBuilder() {
        PullInterfaceDataSource dataSource = new PullInterfaceDataSource();
        return new PullInterfaceRequestBuilder(dataSource);
    }

    public String getEntityName() {
        return "cim_interfaceset";
    }

    public BankLogInfo getBankLogInfo() {
        BankLogInfo logInfo = new BankLogInfo();
        logInfo.setEntityName(this.getEntityName());
        return logInfo;
    }

    public EBGetLoginListResult getEBResult() {
        return this.result;
    }

    public Long getBankCateId() {
        return this.bankCate.getLong("id");
    }
}

