/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.ebservice.service.supermarket;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.bussiness.opservice.ebservice.request.SuperMarketPullPrdRequestBuilder;
import kd.tmc.cim.bussiness.opservice.ebservice.request.datasource.supermarket.SupermarketPullPrdDataSource;
import kd.tmc.cim.bussiness.opservice.ebservice.service.supermarket.PrdCardService;
import kd.tmc.cim.common.enums.SupermarketCardEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.SuperMarketHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.PageQueryEBResult;
import kd.tmc.fbp.service.ebservice.log.BankLogInfo;
import kd.tmc.fbp.service.ebservice.request.IEBRequestBuilder;
import kd.tmc.fbp.service.ebservice.service.IEBService;
import org.apache.commons.lang3.tuple.Pair;

public class SuperMarketPullPrdService
implements IEBService<PageQueryEBResult> {
    private Map paraMap;
    private PageQueryEBResult ebResult;
    private static final Log LOG = LogFactory.getLog(SuperMarketPullPrdService.class);

    public SuperMarketPullPrdService(Map paraMap) {
        this.paraMap = paraMap;
        this.ebResult = new PageQueryEBResult();
    }

    public boolean validate() {
        return true;
    }

    public void beforeRequest() {
    }

    public void rollback(String errMsg, Exception e) {
    }

    public void handleEBException(String resultBody, String errMsg, Exception e) {
        this.ebResult.setStatusCode(EBResultStatusCode.ERROR);
        LOG.info("\u672c\u6279\u6b21\u4ece\u94f6\u884c\u540c\u6b65\u6570\u636e\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)errMsg);
        JSONObject bodyJson = JSON.parseObject((String)resultBody);
        String msg = ResManager.loadKDString((String)"\u5728\u7ebf\u83b7\u53d6\u7406\u8d22\u4ea7\u54c1\u65f6\uff0c\u94f6\u4f01\u8fd4\u56de\u7684\u660e\u7ec6\u4e3a\u7a7a\u3002\u8bf7\u67e5\u770b\u540c\u6b65\u65e5\u5fd7\u4e86\u89e3\u8be6\u60c5\u3002", (String)"SuperMarketPullPrdService_1", (String)"tmc-cim-business", (Object[])new Object[0]);
        if (EmptyUtil.isEmpty((Object)bodyJson)) {
            throw new KDBizException(msg);
        }
        String detailStr = JSONObject.toJSONString((Object)bodyJson.get((Object)"details"));
        List detailList = JSONObject.parseArray((String)detailStr, JSONObject.class);
        if (EmptyUtil.isEmpty((Collection)detailList)) {
            throw new KDBizException(msg);
        }
    }

    public void handleResultBody(String resultBody) {
        List<JSONObject> detailList = this.parseResponseBodyStr(resultBody);
        LOG.info("\u672c\u6279\u6b21\u4ece\u94f6\u884c\u62c9\u56de\u6570\u636e{}\u6761", (Object)detailList.size());
        SupermarketCardEnum cardEnum = this.buildPrdCardEntityPair(detailList);
        LOG.info("\u8fd4\u56de\u62a5\u6587\u4e2d\u7684\u94f6\u884c\u7c7b\u522b\u4e3b\u952e:{},\u5bf9\u5e94\u7406\u8d22\u4ea7\u54c1\u5361\u7247\u5b9e\u4f53:{}", (Object)cardEnum.getBankCateId(), (Object)cardEnum.getCardEntity());
        Pair<Map<String, DynamicObject>, Map<Long, DynamicObject>> mapPair = this.buildMarketMapping(detailList, cardEnum);
        Map<String, Long> currencyNumToIdMap = this.turnCurrencyNumToId(detailList);
        this.saveData(detailList, cardEnum, mapPair, currencyNumToIdMap);
        this.ebResult.setStatusCode(EBResultStatusCode.SUCCESS);
        LOG.info("\u672c\u6279\u6b21\u4ece\u94f6\u884c\u540c\u6b65\u66f4\u65b0\u6570\u636e\u6210\u529f\u3002");
    }

    private void saveData(List<JSONObject> detailList, SupermarketCardEnum cardEnum, Pair<Map<String, DynamicObject>, Map<Long, DynamicObject>> mapPair, Map<String, Long> currencyNumToIdMap) {
        int dataSize = detailList.size();
        ArrayList<DynamicObject> marketBillList = new ArrayList<DynamicObject>(dataSize);
        ArrayList<DynamicObject> cardBillList = new ArrayList<DynamicObject>(dataSize);
        for (int i = 0; i < detailList.size(); ++i) {
            JSONObject row = detailList.get(i);
            this.dealEveryRow(row, cardEnum, mapPair, currencyNumToIdMap, marketBillList, cardBillList);
        }
        if (EmptyUtil.isNoEmpty(marketBillList)) {
            TmcDataServiceHelper.save((DynamicObject[])marketBillList.toArray(new DynamicObject[0]));
        }
        if (EmptyUtil.isNoEmpty(cardBillList)) {
            TmcDataServiceHelper.save((DynamicObject[])cardBillList.toArray(new DynamicObject[0]));
        }
    }

    private List<JSONObject> parseResponseBodyStr(String response) {
        JSONObject bodyJson = JSON.parseObject((String)response);
        this.ebResult.setLastPage(bodyJson.getBoolean("lastPage"));
        String detailStr = JSONObject.toJSONString((Object)bodyJson.get((Object)"details"));
        return JSONObject.parseArray((String)detailStr, JSONObject.class);
    }

    private SupermarketCardEnum buildPrdCardEntityPair(List<JSONObject> detailList) {
        String bankLoginID = detailList.get(0).getString("bankLoginID");
        Long bankCateId = SuperMarketHelper.getBankCateIdByInterFace((String)bankLoginID);
        SupermarketCardEnum cardEnum = SupermarketCardEnum.getEnumByBankCateId((Long)bankCateId);
        return cardEnum;
    }

    private Pair<Map<String, DynamicObject>, Map<Long, DynamicObject>> buildMarketMapping(List<JSONObject> detailList, SupermarketCardEnum cardEnum) {
        Map<Object, Object> noToDynMap = new HashMap(8);
        Map<Object, Object> idToDynMap = new HashMap(8);
        QFilter qFilter = new QFilter("bankcate", "=", (Object)cardEnum.getBankCateId());
        List productCodeList = detailList.stream().map(r -> r.getString("productCode")).collect(Collectors.toList());
        qFilter.and(new QFilter("number", "in", productCodeList));
        List marketIds = QueryServiceHelper.queryPrimaryKeys((String)"cim_supermarket", (QFilter[])qFilter.toArray(), (String)"", (int)-1);
        if (EmptyUtil.isNoEmpty((Object)marketIds)) {
            DynamicObject[] marketBills = TmcDataServiceHelper.load((Object[])marketIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cim_supermarket"));
            noToDynMap = Arrays.stream(marketBills).collect(Collectors.toMap(r -> r.getString("number"), r -> r));
            Object[] prdCardIds = Arrays.stream(marketBills).map(r -> r.getLong("prdcardid")).toArray();
            DynamicObject[] prdCardBills = TmcDataServiceHelper.load((Object[])prdCardIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)cardEnum.getCardEntity()));
            idToDynMap = Arrays.stream(prdCardBills).collect(Collectors.toMap(r -> r.getLong("id"), r -> r));
        }
        return Pair.of(noToDynMap, idToDynMap);
    }

    public IEBRequestBuilder getRequestBuilder() {
        SupermarketPullPrdDataSource pullPrdDataSource = new SupermarketPullPrdDataSource(this.paraMap);
        return new SuperMarketPullPrdRequestBuilder(pullPrdDataSource);
    }

    public String getEntityName() {
        return "cim_supermarket";
    }

    public BankLogInfo getBankLogInfo() {
        BankLogInfo logInfo = new BankLogInfo();
        logInfo.setEntityName(this.getEntityName());
        return logInfo;
    }

    public PageQueryEBResult getEBResult() {
        return this.ebResult;
    }

    public Long getBankCateId() {
        return null;
    }

    private Pair<DynamicObject, DynamicObject> buildSupermarketAndCard(JSONObject row, SupermarketCardEnum cardEnum, Pair<Map<String, DynamicObject>, Map<Long, DynamicObject>> mapPair) {
        DynamicObject prdCardBill;
        String productCode = row.getString("productCode");
        DynamicObject marketBill = (DynamicObject)((Map)mapPair.getLeft()).get(productCode);
        if (EmptyUtil.isEmpty((DynamicObject)marketBill)) {
            marketBill = TmcDataServiceHelper.newDynamicObject((String)"cim_supermarket");
            prdCardBill = TmcDataServiceHelper.newDynamicObject((String)cardEnum.getCardEntity());
        } else {
            prdCardBill = (DynamicObject)((Map)mapPair.getRight()).get(marketBill.getLong("prdcardid"));
        }
        return Pair.of((Object)marketBill, (Object)prdCardBill);
    }

    private void dealEveryRow(JSONObject row, SupermarketCardEnum cardEnum, Pair<Map<String, DynamicObject>, Map<Long, DynamicObject>> mapPair, Map<String, Long> currencyNumToIdMap, List<DynamicObject> marketBillList, List<DynamicObject> cardBillList) {
        Pair<DynamicObject, DynamicObject> marketPair = this.buildSupermarketAndCard(row, cardEnum, mapPair);
        this.setSupermarketBill(row, marketPair, cardEnum, currencyNumToIdMap);
        this.bindRelation(marketPair);
        String className = cardEnum.getClassName();
        PrdCardService cardService = null;
        try {
            cardService = (PrdCardService)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            LOG.info("\u7c7b\u52a0\u8f7d\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5SupermarketCardEnum\u679a\u4e3e\u7c7b\u7684\u7c7b\u540d\u914d\u7f6e");
        }
        if (cardService != null) {
            cardService.execute(row, marketPair, currencyNumToIdMap);
        }
        marketBillList.add((DynamicObject)marketPair.getLeft());
        cardBillList.add((DynamicObject)marketPair.getRight());
    }

    private void bindRelation(Pair<DynamicObject, DynamicObject> marketPair) {
        DynamicObject marketBill = (DynamicObject)marketPair.getLeft();
        DynamicObject prdCardBill = (DynamicObject)marketPair.getRight();
        if (EmptyUtil.isEmpty((Long)prdCardBill.getLong("id"))) {
            long cardId = DB.genLongId((String)"cim_supermarket");
            prdCardBill.set("id", (Object)cardId);
        }
        if (EmptyUtil.isEmpty((Long)marketBill.getLong("prdcardid"))) {
            marketBill.set("prdcardid", (Object)prdCardBill.getLong("id"));
        }
    }

    private void setSupermarketBill(JSONObject row, Pair<DynamicObject, DynamicObject> marketPair, SupermarketCardEnum cardEnum, Map<String, Long> currencyNumToIdMap) {
        DynamicObject marketBill = (DynamicObject)marketPair.getLeft();
        marketBill.set("bankcate", (Object)cardEnum.getBankCateId());
        marketBill.set("number", (Object)row.getString("productCode"));
        marketBill.set("name", (Object)row.getString("productName"));
        marketBill.set("currency", (Object)currencyNumToIdMap.get(row.getString("currency")));
        marketBill.set("latestdate", (Object)row.getDate("modifyTime"));
        marketBill.set("datasource", (Object)TradeChannelEnum.ONLINE.getValue());
        marketBill.set("status", (Object)BillStatusEnum.AUDIT.getValue());
        marketBill.set("enable", (Object)"1");
    }

    private Map<String, Long> turnCurrencyNumToId(List<JSONObject> detailList) {
        Set currencyNumber = detailList.stream().map(r -> r.getString("currency")).collect(Collectors.toSet());
        QFilter currencyFilter = new QFilter("number", "in", currencyNumber);
        DynamicObjectCollection bdCurrency = QueryServiceHelper.query((String)"bd_currency", (String)"id,number", (QFilter[])new QFilter[]{currencyFilter});
        return bdCurrency.stream().collect(Collectors.toMap(r -> r.getString("number"), r -> r.getLong("id")));
    }
}

