/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.init;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.cim.common.helper.BusinessHelper;
import kd.tmc.cim.common.helper.DepositInitHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Triple;

public class DepositInitAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("handredeemamt");
        selector.add("handrevenueamt");
        selector.add("amount");
        selector.add("redeemamount");
        selector.add("lastredeemdate");
        selector.add("surplusamount");
        selector.add("totalamount");
        selector.add("lastrevenuedate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject initBill : dataEntities) {
            this.resetInitBill(initBill);
        }
    }

    private void resetInitBill(DynamicObject initBill) {
        initBill.set("redeemamount", null);
        initBill.set("lastredeemdate", null);
        initBill.set("surplusamount", (Object)initBill.getBigDecimal("amount"));
        initBill.set("totalamount", null);
        initBill.set("lastrevenuedate", null);
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        Triple entityTriple = DepositInitHelper.getEntityTriple((String)dataEntities[0].getDynamicObjectType().getName());
        this.dealInitReleaseBill(dataEntities, (Triple<String, String, String>)entityTriple);
        this.dealInitRevenueBill(dataEntities, (Triple<String, String, String>)entityTriple);
        BusinessHelper.addAttachments((DynamicObject[])dataEntities, (String)((String)entityTriple.getLeft()));
    }

    private void dealInitReleaseBill(DynamicObject[] dataEntities, Triple<String, String, String> entityTriple) {
        DynamicObject[] depositBills;
        Object[] needReleaseIds = Arrays.stream(dataEntities).filter(r -> EmptyUtil.isNoEmpty((BigDecimal)r.getBigDecimal("handredeemamt"))).map(r -> r.getPkValue()).toArray();
        if (EmptyUtil.isEmpty((Object[])needReleaseIds)) {
            return;
        }
        for (DynamicObject depositBill : depositBills = TmcDataServiceHelper.load((Object[])needReleaseIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)((String)entityTriple.getLeft())))) {
            this.produceReleaseBill(depositBill, entityTriple);
        }
    }

    private void dealInitRevenueBill(DynamicObject[] dataEntities, Triple<String, String, String> entityTriple) {
        DynamicObject[] depositBills;
        Object[] needRevenueIds = Arrays.stream(dataEntities).filter(r -> EmptyUtil.isNoEmpty((BigDecimal)r.getBigDecimal("handrevenueamt"))).map(r -> r.getPkValue()).toArray();
        if (EmptyUtil.isEmpty((Object[])needRevenueIds)) {
            return;
        }
        for (DynamicObject depositBill : depositBills = TmcDataServiceHelper.load((Object[])needRevenueIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)((String)entityTriple.getLeft())))) {
            this.produceRevenueBill(depositBill, entityTriple);
        }
    }

    private void produceReleaseBill(DynamicObject depositBill, Triple<String, String, String> entityTriple) {
        BigDecimal handRedeemAmt = depositBill.getBigDecimal("handredeemamt");
        if (EmptyUtil.isEmpty((BigDecimal)handRedeemAmt)) {
            return;
        }
        DynamicObject[] releaseBills = TmcBotpHelper.push((DynamicObject)depositBill, (String)((String)entityTriple.getMiddle()));
        DynamicObject releaseBill = releaseBills[0];
        DepositInitHelper.setReleaseInitBill((DynamicObject)releaseBill, (DynamicObject)depositBill, (Date)depositBill.getDate("handlastredeemdate"), (String)((String)entityTriple.getLeft()));
        OperateOption option = OperateOption.create();
        option.setVariableValue("WF", "TRUE");
        OperationResult submitResult = TmcOperateServiceHelper.execOperate((String)"submit", (String)((String)entityTriple.getMiddle()), (DynamicObject[])new DynamicObject[]{releaseBill}, (OperateOption)option);
        if (EmptyUtil.isNoEmpty((Object)submitResult)) {
            TmcOperateServiceHelper.execOperate((String)"audit", (String)((String)entityTriple.getMiddle()), (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
        }
    }

    private void produceRevenueBill(DynamicObject depositBill, Triple<String, String, String> entityTriple) {
        BigDecimal handRevenueAmt = depositBill.getBigDecimal("handrevenueamt");
        if (EmptyUtil.isEmpty((BigDecimal)handRevenueAmt)) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("WF", "TRUE");
        List revenueIds = DepositInitHelper.setRevenueInitBill((DynamicObject)depositBill, (BigDecimal)handRevenueAmt, (String)((String)entityTriple.getRight()), (OperateOption)option);
        OperationResult submitResult = TmcOperateServiceHelper.execOperate((String)"submit", (String)((String)entityTriple.getRight()), (Object[])revenueIds.toArray(), (OperateOption)option);
        if (EmptyUtil.isNoEmpty((Object)submitResult)) {
            TmcOperateServiceHelper.execOperate((String)"audit", (String)((String)entityTriple.getRight()), (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
        }
    }
}

