/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.init;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.helper.DepositInitHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Triple;

public class DepositInitHistoryUpdateService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("handredeemamt");
        selector.add("handrevenueamt");
        selector.add("amount");
        selector.add("redeemamount");
        selector.add("lastredeemdate");
        selector.add("surplusamount");
        selector.add("totalamount");
        selector.add("lastrevenuedate");
        selector.add("handlastrevenuedate");
        selector.add("handlastredeemdate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Triple entityTriple = DepositInitHelper.getEntityTriple((String)dataEntities[0].getDynamicObjectType().getName());
        this.dealInitReleaseBill(dataEntities, (Triple<String, String, String>)entityTriple);
        this.dealInitRevenueBill(dataEntities, (Triple<String, String, String>)entityTriple);
        this.updateHandLastRedeemDate(dataEntities);
    }

    private void updateHandLastRedeemDate(DynamicObject[] dataEntities) {
        DynamicObject[] depositBills;
        Object[] initBillIds = Arrays.stream(dataEntities).filter(r -> EmptyUtil.isNoEmpty((BigDecimal)r.getBigDecimal("handredeemamt")) && EmptyUtil.isNoEmpty((Object)r.getDate("handlastrevenuedate"))).map(r -> r.getPkValue()).toArray();
        if (EmptyUtil.isEmpty((Object[])initBillIds)) {
            return;
        }
        for (DynamicObject initBill : depositBills = TmcDataServiceHelper.load((String)"cim_deposit", (String)"handlastredeemdate,handlastrevenuedate,lastredeemdate", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)initBillIds)}, (String)"")) {
            Date handLastRedeemDay = DateUtils.getNextDay((Date)initBill.getDate("handlastrevenuedate"), (int)1);
            initBill.set("handlastredeemdate", (Object)handLastRedeemDay);
            if (!EmptyUtil.isEmpty((Object)initBill.getDate("lastredeemdate"))) continue;
            initBill.set("lastredeemdate", (Object)handLastRedeemDay);
        }
        SaveServiceHelper.save((DynamicObject[])depositBills);
    }

    private void dealInitReleaseBill(DynamicObject[] dataEntities, Triple<String, String, String> entityTriple) {
        DynamicObject[] depositBills;
        Object[] needReleaseIds = Arrays.stream(dataEntities).filter(r -> EmptyUtil.isNoEmpty((BigDecimal)r.getBigDecimal("handredeemamt"))).map(r -> r.getPkValue()).toArray();
        if (EmptyUtil.isEmpty((Object[])needReleaseIds)) {
            return;
        }
        for (DynamicObject depositBill : depositBills = TmcDataServiceHelper.load((Object[])needReleaseIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)((String)entityTriple.getLeft())))) {
            this.produceReleaseBill(depositBill, entityTriple);
        }
    }

    private void dealInitRevenueBill(DynamicObject[] dataEntities, Triple<String, String, String> entityTriple) {
        DynamicObject[] revenueBills;
        Object[] needRevenueIds = Arrays.stream(dataEntities).filter(r -> EmptyUtil.isNoEmpty((BigDecimal)r.getBigDecimal("handrevenueamt"))).map(r -> r.getPkValue()).toArray();
        if (EmptyUtil.isEmpty((Object[])needRevenueIds)) {
            return;
        }
        DynamicObject[] depositBills = TmcDataServiceHelper.load((Object[])needRevenueIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)((String)entityTriple.getLeft())));
        ArrayList<Object> revenueIdList = new ArrayList<Object>(dataEntities.length);
        for (DynamicObject depositBill : depositBills) {
            this.produceRevenueBill(depositBill, entityTriple, revenueIdList);
        }
        for (DynamicObject revenueBill : revenueBills = TmcDataServiceHelper.load((String)"cim_dptrevenue", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", revenueIdList)})) {
            revenueBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])revenueBills);
        for (DynamicObject depositBill : depositBills) {
            DepositHelper.resetRevenueProjectEntry((DynamicObject)depositBill, (String)"add");
        }
        SaveServiceHelper.save((DynamicObject[])depositBills);
    }

    private void produceReleaseBill(DynamicObject depositBill, Triple<String, String, String> entityTriple) {
        DynamicObject[] dbReleaseBills;
        DynamicObject[] releaseBills = TmcBotpHelper.push((DynamicObject)depositBill, (String)((String)entityTriple.getMiddle()));
        DynamicObject releaseBill = releaseBills[0];
        Date lastRevenueDate = depositBill.getDate("handlastrevenuedate");
        Date lastRedeemDate = DateUtils.getNextDay((Date)lastRevenueDate, (int)1);
        DepositInitHelper.setReleaseInitBill((DynamicObject)releaseBill, (DynamicObject)depositBill, (Date)lastRedeemDate, (String)((String)entityTriple.getLeft()));
        releaseBill.set("lastredeemdate", null);
        releaseBill.set("surplusamount", (Object)depositBill.getBigDecimal("amount"));
        OperateOption option = OperateOption.create();
        OperationResult saveResult = TmcOperateServiceHelper.execOperate((String)"save", (String)((String)entityTriple.getMiddle()), (DynamicObject[])releaseBills, (OperateOption)option);
        for (DynamicObject dbRelease : dbReleaseBills = TmcDataServiceHelper.load((String)((String)entityTriple.getMiddle()), (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)saveResult.getSuccessPkIds())})) {
            dbRelease.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])dbReleaseBills);
    }

    private void produceRevenueBill(DynamicObject depositBill, Triple<String, String, String> entityTriple, List<Object> revenueIdList) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("pass_pushrevenue_validate", "true");
        List list = DepositInitHelper.setRevenueInitBill((DynamicObject)depositBill, (BigDecimal)depositBill.getBigDecimal("handrevenueamt"), (String)((String)entityTriple.getRight()), (OperateOption)option);
        revenueIdList.addAll(list);
    }
}

