/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.init;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositInitSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("amount");
        selector.add("isinit");
        selector.add("handredeemamt");
        selector.add("surplusamount");
        selector.add("redeemamount");
        selector.add("totalamount");
        selector.add("handrevenueamt");
        selector.add("handlastrevenuedate");
        selector.add("lastrevenuedate");
        selector.add("handendpredate");
        selector.add("endpreinstdate");
        selector.add("lastredeemdate");
        selector.add("handlastredeemdate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject initBill : dataEntities) {
            if (EmptyUtil.isEmpty((String)initBill.getString("billno"))) {
                String formId = initBill.getDynamicObjectType().getName();
                String codeRuleEntity = "";
                switch (formId) {
                    case "cim_noticedeposit_init": {
                        codeRuleEntity = "cim_noticedeposit";
                        break;
                    }
                    case "ifm_deposit_init": {
                        codeRuleEntity = "ifm_deposit";
                        break;
                    }
                    case "ifm_noticedeposit_init": {
                        codeRuleEntity = "ifm_notice_deposit";
                        break;
                    }
                    default: {
                        codeRuleEntity = "cim_deposit";
                    }
                }
                Object orgId = initBill.getDynamicObject("org").getPkValue();
                String billNo = CodeRuleHelper.generateNumber((String)codeRuleEntity, (DynamicObject)TmcDataServiceHelper.newDynamicObject((String)codeRuleEntity), (String)orgId.toString(), (String)"");
                initBill.set("billno", (Object)billNo);
            }
            this.setInitBillColumn(initBill);
        }
    }

    private void setInitBillColumn(DynamicObject initBill) {
        initBill.set("redeemamount", (Object)initBill.getBigDecimal("handredeemamt"));
        BigDecimal depAmt = Optional.ofNullable(initBill.getBigDecimal("amount")).orElse(BigDecimal.ZERO);
        BigDecimal rerAmt = Optional.ofNullable(initBill.getBigDecimal("handredeemamt")).orElse(BigDecimal.ZERO);
        BigDecimal surpAmt = depAmt.subtract(rerAmt);
        initBill.set("surplusamount", (Object)(surpAmt.compareTo(BigDecimal.ZERO) > 0 ? surpAmt : BigDecimal.ZERO));
        initBill.set("totalamount", (Object)initBill.getBigDecimal("handrevenueamt"));
        Date handLastRevDate = initBill.getDate("handlastrevenuedate");
        initBill.set("lastrevenuedate", (Object)handLastRevDate);
        Date handIntPreDate = initBill.getDate("handendpredate");
        if (EmptyUtil.isEmpty((Object)handIntPreDate) && EmptyUtil.isNoEmpty((Object)handLastRevDate)) {
            handIntPreDate = handLastRevDate;
        }
        initBill.set("endpreinstdate", (Object)handIntPreDate);
        initBill.set("lastredeemdate", (Object)initBill.getDate("handlastredeemdate"));
    }
}

