/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.init;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.helper.BusinessHelper;
import kd.tmc.cim.common.helper.DepositInitHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Triple;

public class DepositInitUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("handredeemamt");
        selector.add("handrevenueamt");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        Triple entityTriple = DepositInitHelper.getEntityTriple((String)dataEntities[0].getDynamicObjectType().getName());
        this.cancelInitReleaseBill(dataEntities, (Triple<String, String, String>)entityTriple);
        this.cancelInitRevenueBill(dataEntities, (Triple<String, String, String>)entityTriple);
        this.resetInitBill(dataEntities);
        BusinessHelper.deleteAttachment((DynamicObject[])dataEntities, (String)((String)entityTriple.getLeft()));
    }

    private void cancelInitReleaseBill(DynamicObject[] dataEntities, Triple<String, String, String> entityTriple) {
        DynamicObject[] depositBills;
        Object[] cancelReleaseIds = Arrays.stream(dataEntities).filter(r -> EmptyUtil.isNoEmpty((BigDecimal)r.getBigDecimal("handredeemamt"))).map(r -> r.getPkValue()).toArray();
        if (EmptyUtil.isEmpty((Object[])cancelReleaseIds)) {
            return;
        }
        for (DynamicObject depositBill : depositBills = TmcDataServiceHelper.load((Object[])cancelReleaseIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)((String)entityTriple.getLeft())))) {
            this.cancelDownStreamBill(depositBill, (String)entityTriple.getMiddle());
        }
    }

    private void cancelInitRevenueBill(DynamicObject[] dataEntities, Triple<String, String, String> entityTriple) {
        DynamicObject[] depositBills;
        Object[] cancelRevenueIds = Arrays.stream(dataEntities).filter(r -> EmptyUtil.isNoEmpty((BigDecimal)r.getBigDecimal("handrevenueamt"))).map(r -> r.getPkValue()).toArray();
        if (EmptyUtil.isEmpty((Object[])cancelRevenueIds)) {
            return;
        }
        for (DynamicObject depositBill : depositBills = TmcDataServiceHelper.load((Object[])cancelRevenueIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)((String)entityTriple.getLeft())))) {
            this.cancelDownStreamBill(depositBill, (String)entityTriple.getRight());
        }
    }

    private void resetInitBill(DynamicObject[] dataEntities) {
        DynamicObject[] initBills;
        Object[] initBillIds = Arrays.stream(dataEntities).map(r -> r.getPkValue()).toArray();
        for (DynamicObject initBill : initBills = TmcDataServiceHelper.load((Object[])initBillIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)dataEntities[0].getDynamicObjectType().getName()))) {
            BigDecimal handRedeemAmt = initBill.getBigDecimal("handredeemamt");
            initBill.set("redeemamount", (Object)handRedeemAmt);
            initBill.set("lastredeemdate", (Object)initBill.getDate("handlastredeemdate"));
            initBill.set("surplusamount", (Object)initBill.getBigDecimal("amount").subtract(handRedeemAmt));
            initBill.set("totalamount", (Object)initBill.getBigDecimal("handrevenueamt"));
            initBill.set("lastrevenuedate", (Object)initBill.getDate("handlastrevenuedate"));
            initBill.set("bizstatus", (Object)FinServiceStatusEnum.subscribe_ing.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])initBills);
    }

    private void cancelDownStreamBill(DynamicObject depositBill, String entity) {
        QFilter qFilter = new QFilter("sourcebillid", "=", depositBill.getPkValue());
        qFilter.and(new QFilter("isinit", "=", (Object)Boolean.TRUE));
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        List releaseIds = QueryServiceHelper.queryPrimaryKeys((String)entity, (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
        if (EmptyUtil.isEmpty((Collection)releaseIds)) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("pass_isinit_validate", "true");
        TmcOperateServiceHelper.execOperate((String)"unaudit", (String)entity, (Object[])releaseIds.toArray(), (OperateOption)option);
        TmcOperateServiceHelper.execOperate((String)"delete", (String)entity, (Object[])releaseIds.toArray(), (OperateOption)option);
    }
}

