/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.intbatch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IntBillBatchSubmitService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(IntBillBatchSubmitService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entry");
        selector.add("bizdate");
        selector.add("preintdate");
        selector.add("finbillid");
        selector.add("startdate");
        selector.add("enddate");
        selector.add("intdays");
        selector.add("interestamt");
        selector.add("intdetailnum");
        selector.add("intbillid");
        selector.add("actualinstamt");
        selector.add("status");
        selector.add("intcomment");
        selector.add("finbillno");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject batchIntBill : dataEntities) {
            DynamicObjectCollection batchInEntrys = batchIntBill.getDynamicObjectCollection("entry");
            DynamicObject[] finBills = TmcDataServiceHelper.load((Object[])batchInEntrys.stream().map(v -> v.getLong("finbillid")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)CimEntityEnum.cim_finsubscribe.getValue()));
            Map<Long, DynamicObject> idObjMap = Arrays.stream(finBills).collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
            ArrayList intBillIds = new ArrayList(batchInEntrys.size());
            List ids = Arrays.stream(finBills).map(Dyn -> Dyn.getPkValue().toString()).collect(Collectors.toList());
            Map LimitMap = MutexServiceHelper.batchRequest(ids, (String)CimEntityEnum.cim_finsubscribe.getValue(), (String)"submit");
            List lockIds = LimitMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
            try {
                String lockErrorBillNos = batchInEntrys.stream().filter(b -> Boolean.FALSE.equals(LimitMap.get(b.getString("finbillid")))).map(b -> b.getString("finbillno")).collect(Collectors.joining(","));
                if (EmptyUtil.isNoEmpty((String)lockErrorBillNos)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u4e0b\u63a8\u7406\u8d22\u9884\u63d0\u6536\u76ca\u5355, \u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"IntBillBatchSubmitService_2", (String)"tmc-cim-business", (Object[])new Object[0]), lockErrorBillNos));
                }
                for (DynamicObject batchIntEntry : batchInEntrys) {
                    DynamicObject finBill = idObjMap.get(batchIntEntry.getLong("finbillid"));
                    DynamicObject[] targetBills = TmcBotpHelper.push((DynamicObject)finBill, (String)"cim_intbill_revenue");
                    targetBills[0].set("intbatchbillid", (Object)batchIntBill.getLong("id"));
                    targetBills[0].set("bizdate", (Object)batchIntBill.getDate("bizdate"));
                    targetBills[0].set("revenuestartdate", (Object)batchIntEntry.getDate("startdate"));
                    targetBills[0].set("revenueenddate", (Object)batchIntEntry.getDate("enddate"));
                    targetBills[0].set("revenuedays", (Object)batchIntEntry.getInt("intdays"));
                    targetBills[0].set("amount", (Object)batchIntEntry.getBigDecimal("actualinstamt"));
                    targetBills[0].set("revenueamount", (Object)batchIntEntry.getBigDecimal("interestamt"));
                    targetBills[0].set("nowriteoffamt", (Object)batchIntEntry.getBigDecimal("actualinstamt"));
                    targetBills[0].set("expiredate", (Object)batchIntBill.getDate("preintdate"));
                    this.saveRelateBill(batchIntEntry, targetBills, intBillIds);
                }
            }
            catch (Exception e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u7406\u8d22\u9884\u63d0\u6536\u76ca\u5355\u5931\u8d25:%s\u3002", (String)"IntBillBatchSubmitService_3", (String)"tmc-cim-business", (Object[])new Object[0]), e.getMessage()));
            }
            finally {
                if (!lockIds.isEmpty()) {
                    MutexServiceHelper.batchRelease(lockIds, (String)CimEntityEnum.cim_finsubscribe.getValue(), (String)"submit");
                }
            }
            this.checkFail(intBillIds, batchIntBill, batchInEntrys);
        }
    }

    private void checkFail(List intBillIds, DynamicObject batchIntBill, DynamicObjectCollection batchInEntrys) {
        if (intBillIds.size() < batchInEntrys.size()) {
            DynamicObjectCollection batchEntrys = batchIntBill.getDynamicObjectCollection("entry");
            for (DynamicObject intEntry : batchEntrys) {
                if (!intBillIds.contains(intEntry.getLong("intbillid"))) continue;
                intEntry.set("status", (Object)"");
                intEntry.set("intcomment", (Object)"");
                intEntry.set("intdetailnum", null);
                intEntry.set("intbillid", null);
            }
            batchIntBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            TmcOperateServiceHelper.execOperate((String)"save", (String)batchIntBill.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{batchIntBill}, (OperateOption)OperateOption.create(), (boolean)true);
            throw new KDBizException(ResManager.loadKDString((String)"\u6709\u63d0\u4ea4\u5931\u8d25\u7684\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4\uff0c\u6216\u8005\u5220\u9664\u3002", (String)"IntBillBatchSubmitService_0", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }

    private void saveRelateBill(DynamicObject batchIntEntry, DynamicObject[] targetBills, List intBillIds) {
        if (EmptyUtil.isEmpty((Object[])targetBills)) {
            return;
        }
        String entityName = targetBills[0].getDataEntityType().getName();
        OperationResult result = null;
        OperateOption operate = OperateOption.create();
        operate.setVariableValue("intbatch", "true");
        operate.setVariableValue("WF", "TRUE");
        try {
            result = TmcOperateServiceHelper.execOperate((String)"submit", (String)entityName, (DynamicObject[])targetBills, (OperateOption)operate, (boolean)false);
        }
        catch (Exception e) {
            batchIntEntry.set("status", (Object)"fail");
            batchIntEntry.set("intcomment", (Object)String.format(ResManager.loadKDString((String)"\u9884\u63d0\u5355\u751f\u6210\u5931\u8d25\uff1a%s\u3002", (String)"IntBillBatchSubmitService_1", (String)"tmc-cim-business", (Object[])new Object[0]), e.getMessage().length() > 50 ? e.getMessage().substring(0, 40) : e.getMessage()));
        }
        if (result == null) {
            return;
        }
        Object intBillId = result.getSuccessPkIds().toArray()[0];
        if (EmptyUtil.isNoEmpty((Object)result.getBillNos())) {
            batchIntEntry.set("status", (Object)"success");
            batchIntEntry.set("intdetailnum", result.getBillNos().values().toArray()[0]);
            batchIntEntry.set("intbillid", intBillId);
            intBillIds.add(intBillId);
        }
    }
}

