/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.intbatch;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IntBillBatchUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entry");
        selector.add("intbillid");
        selector.add("finbillid");
        selector.add("interestamt");
        selector.add("intdetailnum");
        selector.add("status");
        selector.add("intcomment");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject batchIntBill : dataEntities) {
            DynamicObjectCollection batchEntryIntBills = batchIntBill.getDynamicObjectCollection("entry");
            for (DynamicObject batchIntEntry : batchEntryIntBills) {
                Long id = batchIntEntry.getLong("intbillid");
                if (!EmptyUtil.isNoEmpty((Long)id) || !TmcDataServiceHelper.exists((Object)id, (String)"cim_intbill_revenue")) continue;
                DynamicObject intBill = TmcDataServiceHelper.loadSingle((Object)id, (String)"cim_intbill_revenue", (String)"id,billstatus");
                String billStatus = intBill.getString("billstatus");
                if (BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                    TmcOperateServiceHelper.execOperate((String)"unaudit", (String)"cim_intbill_revenue", (Object[])new Object[]{id}, (OperateOption)OperateOption.create());
                }
                if (BillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
                    TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)"cim_intbill_revenue", (Object[])new Object[]{id}, (OperateOption)OperateOption.create());
                }
                TmcOperateServiceHelper.execOperate((String)"delete", (String)"cim_intbill_revenue", (Object[])new Object[]{id}, (OperateOption)OperateOption.create());
                batchIntEntry.set("intdetailnum", null);
                batchIntEntry.set("intbillid", null);
                batchIntEntry.set("intcomment", (Object)"");
                batchIntEntry.set("status", (Object)"");
            }
        }
    }
}

