/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.intbatch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.OperaTypeEnum;
import kd.tmc.cim.common.enums.WriteOffStatusEnum;
import kd.tmc.cim.common.helper.RevenuePlanCalHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IntRevenueBillWriteOffService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("writeoffbillno");
        sic.add("intbatchbillid");
        sic.add("writeoffpreintbillid");
        sic.add("finbillno");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashSet<Long> finBillIds = new HashSet<Long>(16);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)dataEntities[0].getDynamicObjectType().getName());
        DynamicObject[] intRevBills = TmcDataServiceHelper.load((Object[])Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)entityType);
        ArrayList<DynamicObject> redWriteOffInt = new ArrayList<DynamicObject>(dataEntities.length);
        Long userId = RequestContext.get().getCurrUserId();
        String batchNoParam = (String)this.getOperationVariable().get("batchnoid");
        long batchNoId = EmptyUtil.isEmpty((String)batchNoParam) ? 0L : Long.parseLong(batchNoParam);
        for (DynamicObject intRevBill : intRevBills) {
            DynamicObject newPreInt = TmcDataServiceHelper.clone((DynamicObject)intRevBill);
            newPreInt.set("billhead_lk", null);
            newPreInt.set("billno", (Object)"");
            newPreInt.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            newPreInt.set("writeoffpreintbillid", (Object)intRevBill.getLong("id"));
            newPreInt.set("operatype", (Object)OperaTypeEnum.WRITEOFFREV.getValue());
            newPreInt.set("writeoffamt", (Object)intRevBill.getBigDecimal("amount"));
            newPreInt.set("nowriteoffamt", (Object)BigDecimal.ZERO);
            newPreInt.set("batchnoid", (Object)batchNoId);
            newPreInt.set("createtime", (Object)new Date());
            newPreInt.set("creator", (Object)TmcDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user"));
            newPreInt.set("writeoffstatus", (Object)WriteOffStatusEnum.RED_WRITEOFF.getValue());
            redWriteOffInt.add(newPreInt);
            intRevBill.set("writeoffstatus", (Object)WriteOffStatusEnum.RED_WRITEOFF.getValue());
            intRevBill.set("writeoffamt", (Object)intRevBill.getBigDecimal("amount"));
            intRevBill.set("nowriteoffamt", (Object)BigDecimal.ZERO);
            intRevBill.set("modifier", (Object)userId);
            intRevBill.set("modifytime", (Object)new Date());
            intRevBill.set("batchnoid", (Object)batchNoId);
            finBillIds.add(intRevBill.getDynamicObject("finbillno").getLong("id"));
        }
        OperateOption opOption = OperateOption.create();
        opOption.setVariableValue("redwriteoffop", "redwriteoffop");
        opOption.setVariableValue("WF", "TRUE");
        OperationResult submitRes = TmcOperateServiceHelper.execOperate((String)"submit", (String)dataEntities[0].getDataEntityType().getName(), (DynamicObject[])redWriteOffInt.toArray(new DynamicObject[0]), (OperateOption)opOption);
        List redWriteOffPreIntPkIds = submitRes.getSuccessPkIds();
        TmcOperateServiceHelper.execOperate((String)"audit", (String)dataEntities[0].getDataEntityType().getName(), (Object[])redWriteOffPreIntPkIds.toArray(), (OperateOption)opOption);
        SaveServiceHelper.save((DynamicObject[])intRevBills);
        RevenuePlanCalHelper.writeBackLastPreIntDate(finBillIds);
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        DynamicObjectCollection intBill = new DynamicObjectCollection();
        for (DynamicObject intRevBill : dataEntities) {
            Long pkid = intRevBill.getLong("id");
            QFilter qFilter = new QFilter("writeoffpreintbillid", "=", (Object)pkid);
            DynamicObject newRevBill = TmcDataServiceHelper.loadSingle((String)dataEntities[0].getDynamicObjectType().getName(), (String)"id,billno", (QFilter[])qFilter.toArray());
            intRevBill.set("writeoffbillno", (Object)newRevBill.getString("billno"));
            RevenuePlanCalHelper.writeBackIntBatchBillEntrys((DynamicObjectCollection)intBill, (DynamicObject)intRevBill, (Boolean)Boolean.TRUE, (DynamicObject)newRevBill);
        }
        SaveServiceHelper.update((DynamicObject[])((DynamicObject[])intBill.toArray((Object[])new DynamicObject[0])));
        SaveServiceHelper.update((DynamicObject[])dataEntities);
    }
}

