/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.redeem;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.helper.RedeemBillHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RedeemBillSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("finbillno");
        sic.add("isrevenue");
        sic.add("redeemdate");
        sic.add("realrevenue");
        sic.add("surplusamount");
        sic.add("amount");
        sic.add("ispushrev");
        sic.add("redeemway");
        sic.add("combineinst");
        sic.add("recamount");
        sic.add("redeemapply");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntitie : dataEntities) {
            DynamicObject finBillNoF7 = dataEntitie.getDynamicObject("finbillno");
            if (EmptyUtil.isNoEmpty((DynamicObject)finBillNoF7)) {
                TmcBotpHelper.saveRelation((String)CimEntityEnum.cim_finsubscribe.getValue(), (Long)((Long)finBillNoF7.getPkValue()), (String)CimEntityEnum.cim_redeem.getValue(), (Long)((Long)dataEntitie.getPkValue()));
            }
            RedeemBillHelper.dealBotpRelation((DynamicObject)dataEntitie);
            boolean isRevenue = dataEntitie.getBoolean("isrevenue");
            boolean isPushRev = dataEntitie.getBoolean("ispushrev");
            if (isRevenue && isPushRev) {
                OperateOption opOption = OperateOption.create();
                opOption.setVariableValue("redeemDate", DateUtils.formatString((Date)dataEntitie.getDate("redeemdate"), (String)"yyyy-MM-dd"));
                opOption.setVariableValue("realRevenue", String.valueOf(dataEntitie.getBigDecimal("realrevenue")));
                opOption.setVariableValue("surplusAmount", String.valueOf(dataEntitie.getBigDecimal("surplusamount")));
                opOption.setVariableValue("amount", String.valueOf(dataEntitie.getBigDecimal("amount")));
                opOption.setVariableValue("combineinst", String.valueOf(dataEntitie.getBoolean("combineinst")));
                opOption.setVariableValue("from_redeemrevenue", "true");
                TmcOperateServiceHelper.execOperate((String)"pushrevenue", (String)CimEntityEnum.cim_redeem.getValue(), (DynamicObject[])new DynamicObject[]{dataEntitie}, (OperateOption)opOption);
                DynamicObject targetBill = TmcBotpHelper.getTargetBill((String)CimEntityEnum.cim_redeem.getValue(), (Object)dataEntitie.getPkValue(), (String)CimEntityEnum.cim_revenue.getValue());
                if (EmptyUtil.isNoEmpty((DynamicObject)targetBill)) {
                    TmcBotpHelper.deleteRation((String)CimEntityEnum.cim_revenue.getValue(), (Long)((Long)dataEntitie.getPkValue()), (Long)((Long)targetBill.getPkValue()));
                }
            }
            RedeemBillHelper.setRecAmount((DynamicObject)dataEntitie);
        }
        RedeemBillHelper.writeBackFinApply((DynamicObject[])dataEntities);
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject bill : dataEntities) {
            Map botpMap = BFTrackerServiceHelper.findTargetBills((String)CimEntityEnum.cim_redeem.getValue(), (Long[])new Long[]{bill.getLong("id")});
            this.deletePushRegisterBill(botpMap);
        }
    }

    private void deletePushRegisterBill(Map<String, HashSet<Long>> botpMap) {
        Object[] downbillIds = botpMap.entrySet().stream().filter(o -> CimEntityEnum.cim_revenue.getValue().equals(o.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).toArray();
        if (downbillIds.length > 0) {
            TmcOperateServiceHelper.execOperate((String)"delete", (String)CimEntityEnum.cim_revenue.getValue(), (Object[])downbillIds, (OperateOption)OperateOption.create());
        }
    }
}

