/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.revenue;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.OperaTypeEnum;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.cim.common.enums.WriteOffStatusEnum;
import kd.tmc.cim.common.helper.IntBillBatchHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RevenueBillDelService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("finbillno");
        sic.add("revenuesort");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntitie : dataEntities) {
            DynamicObject sourBill;
            String revenueSort = dataEntitie.getString("revenuesort");
            if (RevenueSortEnum.revenue.getValue().equals(revenueSort) && EmptyUtil.isNoEmpty((DynamicObject)(sourBill = TmcBotpHelper.getSourceBill((String)dataEntitie.getDataEntityType().getName(), (Object)dataEntitie.getPkValue(), (String)CimEntityEnum.cim_finsubscribe.getValue())))) {
                TmcBotpHelper.deleteRation((String)dataEntitie.getDataEntityType().getName(), (Long)sourBill.getLong("id"), (Long)dataEntitie.getLong("id"));
            }
            if (!IntBillBatchHelper.isAutoWriteRed((DynamicObject)dataEntitie)) continue;
            this.autoUnRedWriteOff(dataEntitie);
        }
    }

    private void autoUnRedWriteOff(DynamicObject preIntBill) {
        long pkValue = preIntBill.getLong("id");
        QFilter filter = new QFilter("batchnoid", "=", (Object)pkValue);
        filter.and(new QFilter("writeoffstatus", "=", (Object)WriteOffStatusEnum.RED_WRITEOFF.getValue()));
        filter.and(new QFilter("operatype", "=", (Object)OperaTypeEnum.WRITEOFFREV.getValue()));
        DynamicObjectCollection autoRedWriteOffBills = QueryServiceHelper.query((String)"cim_intbill_revenue", (String)"billno,id", (QFilter[])filter.toArray(), (String)"revenuestartdate desc,billno desc");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)autoRedWriteOffBills)) {
            Object[] ids = autoRedWriteOffBills.stream().map(r -> r.getLong("id")).toArray();
            OperateOption operate = OperateOption.create();
            operate.setVariableValue("back", "true");
            TmcOperateServiceHelper.execOperate((String)"unredwriteoff", (String)"cim_intbill_revenue", (Object[])ids, (OperateOption)operate);
        }
    }
}

