/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.revenue;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.OperaTypeEnum;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.cim.common.enums.WriteOffStatusEnum;
import kd.tmc.cim.common.helper.IntBillBatchHelper;
import kd.tmc.cim.common.helper.RevenueCalcHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RevenueBillSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("finbillno");
        sic.add("revenuesort");
        sic.add("revenuestartdate");
        sic.add("revenueenddate");
        sic.add("expiredate");
        sic.add("revenueamount");
        sic.add("entrys");
        sic.add("entrys.seq");
        sic.add("startdate");
        sic.add("enddate");
        sic.add("days");
        sic.add("finamount");
        sic.add("eplanrevenue");
        sic.add("convertdays");
        sic.add("erevenueamount");
        sic.add("datasource");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        if (this.getOperationVariable().containsKey("redwriteoffop")) {
            return;
        }
        for (DynamicObject dataEntitie : dataEntities) {
            String revenueSort = dataEntitie.getString("revenuesort");
            if (RevenueSortEnum.revenue.getValue().equals(revenueSort)) {
                this.createByNormalSubmit(dataEntitie);
            }
            this.dealAutoRedWriteOff(dataEntitie);
        }
    }

    private void createByNormalSubmit(DynamicObject dataEntitie) {
        DynamicObject finBillNoF7 = dataEntitie.getDynamicObject("finbillno");
        if (EmptyUtil.isNoEmpty((DynamicObject)finBillNoF7)) {
            TmcBotpHelper.saveRelation((String)CimEntityEnum.cim_finsubscribe.getValue(), (Long)((Long)finBillNoF7.getPkValue()), (String)dataEntitie.getDataEntityType().getName(), (Long)((Long)dataEntitie.getPkValue()));
            Date beginDate = dataEntitie.getDate("revenuestartdate");
            Date endDate = dataEntitie.getDate("expiredate");
            IntBillInfo intBill = RevenueCalcHelper.callInt((Long)((Long)finBillNoF7.getPkValue()), (Date)beginDate, (Date)endDate);
            if (intBill != null) {
                dataEntitie.set("revenueamount", (Object)intBill.getAmount());
                DynamicObjectCollection entrys = dataEntitie.getDynamicObjectCollection("entrys");
                if (EmptyUtil.isNoEmpty((Object)intBill.getDetails())) {
                    RevenueCalcHelper.addDetail((DynamicObjectCollection)entrys, (List)intBill.getDetails());
                }
            }
        }
    }

    private void dealAutoRedWriteOff(DynamicObject dataEntitie) {
        if (OperaTypeEnum.INTERESTREV.getValue().equals(dataEntitie.getString("datasource")) && OperaTypeEnum.INTERESTREV.getValue().equals(dataEntitie.getString("operatype"))) {
            if (!IntBillBatchHelper.isAutoWriteRed((DynamicObject)dataEntitie)) {
                return;
            }
            QFilter filter = new QFilter("writeoffstatus", "=", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue());
            filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            filter.and("datasource", "=", (Object)OperaTypeEnum.INTERESTREV.getValue());
            filter.and("finbillno", "=", dataEntitie.getDynamicObject("finbillno").getPkValue());
            Object[] unWriteOffPreIntBills = TmcDataServiceHelper.load((String)"cim_intbill_revenue", (String)"id", (QFilter[])filter.toArray());
            if (EmptyUtil.isEmpty((Object[])unWriteOffPreIntBills)) {
                return;
            }
            OperateOption operate = OperateOption.create();
            operate.setVariableValue("autoredwriteoff", "true");
            operate.setVariableValue("batchnoid", String.valueOf(dataEntitie.getLong("id")));
            Object[] ids = Arrays.stream(unWriteOffPreIntBills).map(DataEntityBase::getPkValue).toArray();
            TmcOperateServiceHelper.execOperate((String)"redwriteoff", (String)"cim_intbill_revenue", (Object[])ids, (OperateOption)operate);
        }
    }
}

