/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.scheme;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositSchemeSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("depositapply");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        String saveParam = this.getOperationVariable().getOrDefault("fromdepositapply", null);
        if (EmptyUtil.isNoEmpty((String)saveParam)) {
            this.syncSchemeStatus(dataEntities);
            return;
        }
        for (DynamicObject depositScheme : dataEntities) {
            this.syncSchemeInfo(depositScheme);
            DynamicObject depositApplyDo = depositScheme.getDynamicObject("depositapply");
            if (depositApplyDo != null) {
                depositScheme.set("status", (Object)depositApplyDo.getString("billstatus"));
                continue;
            }
            depositScheme.set("status", (Object)BillStatusEnum.SAVE.getValue());
        }
    }

    private void syncSchemeStatus(DynamicObject[] dataEntities) {
        for (DynamicObject depositScheme : dataEntities) {
            DynamicObject depositApply = depositScheme.getDynamicObject("depositapply");
            if (depositApply == null) continue;
            depositScheme.set("status", (Object)depositApply.getString("billstatus"));
        }
    }

    private void syncSchemeInfo(DynamicObject depositScheme) {
        DynamicObject depositSchemeFromDB = TmcDataServiceHelper.loadSingle((String)"cim_depositscheme", (String)"depositapply", (QFilter[])new QFilter[]{new QFilter("id", "=", depositScheme.getPkValue())});
        DynamicObject depositApply = depositScheme.getDynamicObject("depositapply");
        if (depositApply == null) {
            this.cleanOldDepositRelation(depositSchemeFromDB, depositScheme.getLong("id"));
            return;
        }
        ArrayList<DynamicObject> modifyDepositApplyList = new ArrayList<DynamicObject>(16);
        DynamicObject depositApplyFromDB = TmcDataServiceHelper.loadSingle((Object)depositApply.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_deposit_apply"));
        DynamicObjectCollection schemeEntryList = depositApplyFromDB.getDynamicObjectCollection("entry");
        Map map = schemeEntryList.stream().filter(v -> EmptyUtil.isNoEmpty((Long)v.getLong("e_schemeid"))).collect(Collectors.toMap(v -> v.getLong("e_schemeid"), o -> o, (o1, o2) -> o1, HashMap::new));
        DynamicObject scheme = null;
        if (EmptyUtil.isEmpty((DynamicObject)depositSchemeFromDB) || depositSchemeFromDB.getDynamicObject("depositapply") == null) {
            scheme = schemeEntryList.addNew();
        } else if (depositApply.getString("number").equals(depositSchemeFromDB.getDynamicObject("depositapply").getString("number"))) {
            scheme = (DynamicObject)map.get(depositScheme.getLong("id"));
        } else {
            scheme = schemeEntryList.addNew();
            DynamicObject oldDepositApply = TmcDataServiceHelper.loadSingle((Object)depositSchemeFromDB.getDynamicObject("depositapply").getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_deposit_apply"));
            oldDepositApply.getDynamicObjectCollection("entry").removeIf(row -> row.getLong("e_schemeid") == depositScheme.getLong("id"));
            modifyDepositApplyList.add(oldDepositApply);
        }
        modifyDepositApplyList.add(depositApplyFromDB);
        this.copyProperties(depositScheme, scheme);
        SaveServiceHelper.save((DynamicObject[])modifyDepositApplyList.toArray(new DynamicObject[0]));
    }

    private void cleanOldDepositRelation(DynamicObject depositSchemeFromDB, Long schemeId) {
        if (depositSchemeFromDB == null || EmptyUtil.isEmpty((DynamicObject)depositSchemeFromDB.getDynamicObject("depositapply"))) {
            return;
        }
        ArrayList<DynamicObject> modifyDepositApplyList = new ArrayList<DynamicObject>(16);
        DynamicObject oldDepositApply = TmcDataServiceHelper.loadSingle((Object)depositSchemeFromDB.getDynamicObject("depositapply").getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_deposit_apply"));
        oldDepositApply.getDynamicObjectCollection("entry").removeIf(row -> row.getLong("e_schemeid") == schemeId.longValue());
        modifyDepositApplyList.add(oldDepositApply);
        SaveServiceHelper.save((DynamicObject[])modifyDepositApplyList.toArray(new DynamicObject[0]));
    }

    private void copyProperties(DynamicObject srcObj, DynamicObject targetObj) {
        if (targetObj == null) {
            return;
        }
        DataEntityPropertyCollection properties = targetObj.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            String propName = property.getName();
            if (propName.equals("e_isselect") || propName.equals("e_schemeid") || propName.startsWith("e_depositscheme") || propName.equals("e_explain") || !propName.startsWith("e_")) continue;
            targetObj.set(propName, srcObj.get(propName.replaceFirst("e_", "")));
        }
        targetObj.set("e_schemeid", (Object)srcObj.getLong("id"));
        targetObj.set("e_depositscheme", (Object)srcObj);
        targetObj.set("e_depositscheme_id", (Object)srcObj.getLong("id"));
    }
}

