/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.supermarket;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cim.bussiness.opservice.ebservice.api.EBServiceFacadeImpl;
import kd.tmc.cim.common.helper.SuperMarketHelper;
import kd.tmc.cim.common.property.SuperMarketProp;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.data.PageQueryEBResult;

public abstract class AbstractMarketAutoDeployService
extends AbstractTmcBizOppService {
    private static final Log LOG = LogFactory.getLog(AbstractMarketAutoDeployService.class);

    public void process(DynamicObject[] dataEntities) throws KDException {
        this.pullProductSummary();
    }

    protected void pullProductSummary() {
        HashMap<String, Number> paraMap = new HashMap<String, Number>(8);
        paraMap.put("bankcate", this.getBankCateId());
        Integer pageSize = SuperMarketHelper.getPageSizeFromDB();
        paraMap.put("pageSize", EmptyUtil.isEmpty((Integer)pageSize) ? SuperMarketProp.CONST_PAGESIZE : pageSize);
        LOG.info("\u5206\u9875\u67e5\u8be2\u6bcf\u9875\u6570\u91cf\u4e3a:{}", (Object)pageSize);
        int pageNum = 1;
        LOG.info("\u7406\u8d22\u4ea7\u54c1\u6982\u8981\u4fe1\u606f\u540c\u6b65\u5f00\u59cb\u3002");
        while (true) {
            boolean isLastPage = true;
            paraMap.put("pageNum", pageNum);
            PageQueryEBResult ebResult = new EBServiceFacadeImpl().queryBankInfos("cim_supermarket", paraMap);
            if (ebResult != null && ebResult.getStatusCode() == EBResultStatusCode.SUCCESS) {
                isLastPage = ebResult.getLastPage();
            }
            if (isLastPage) break;
            ++pageNum;
        }
        LOG.info("\u7406\u8d22\u4ea7\u54c1\u6982\u8981\u4fe1\u606f\u540c\u6b65\u5b8c\u6210\u3002");
    }

    protected abstract Long getBankCateId();
}

