/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.supermarket;

import java.util.HashMap;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.bussiness.opservice.ebservice.api.EBServiceFacadeImpl;
import kd.tmc.cim.bussiness.opservice.supermarket.AbstractMarketAutoDeployService;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.SuperMarketHelper;
import kd.tmc.cim.common.property.SuperMarketProp;
import kd.tmc.fbp.common.util.EmptyUtil;

public class MarketCmbAutoDeployService
extends AbstractMarketAutoDeployService {
    private static final Log LOG = LogFactory.getLog(MarketCmbAutoDeployService.class);

    @Override
    public void process(DynamicObject[] dataEntities) throws KDException {
        super.pullProductSummary();
        this.pullCmbProductDetail();
    }

    private void pullCmbProductDetail() {
        QFilter qFilter = new QFilter("datasource", "=", (Object)TradeChannelEnum.ONLINE.getValue());
        qFilter.and(new QFilter("bankcate", "=", (Object)SuperMarketHelper.BANKCATEID_CMB));
        DataSet marketDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cim_supermarket", (String)"number", (QFilter[])qFilter.toArray(), (String)"");
        if (EmptyUtil.isEmpty((Object)marketDs)) {
            return;
        }
        HashMap<String, Object> paraMap = new HashMap<String, Object>(8);
        paraMap.put("bankcate", SuperMarketHelper.BANKCATEID_CMB);
        Integer pageSize = SuperMarketHelper.getPageSizeFromDB();
        paraMap.put("pageSize", EmptyUtil.isEmpty((Integer)pageSize) ? SuperMarketProp.CONST_PAGESIZE : pageSize);
        paraMap.put("pageNum", 1);
        Iterator it = marketDs.iterator();
        LOG.info("\u62db\u884c\u7406\u8d22\u4ea7\u54c1\u8be6\u60c5\u4fe1\u606f\u540c\u6b65\u5f00\u59cb\u3002");
        while (it.hasNext()) {
            Row row = (Row)it.next();
            paraMap.put("productno", row.getString("number"));
            new EBServiceFacadeImpl().queryBankInfos("cim_supermarket", paraMap);
        }
        LOG.info("\u62db\u884c\u7406\u8d22\u4ea7\u54c1\u8be6\u60c5\u4fe1\u606f\u540c\u6b65\u5b8c\u6210\u3002");
    }

    @Override
    protected Long getBankCateId() {
        return SuperMarketHelper.BANKCATEID_CMB;
    }
}

