/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.task;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.ExpireRedepositTypeEnum;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositAuto2ReleaseTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(DepositAuto2ReleaseTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        QFilter[] filters = this.getDepositFilter();
        List depositBillIds = QueryServiceHelper.queryPrimaryKeys((String)"cim_deposit", (QFilter[])filters, (String)"", (int)-1);
        if (EmptyUtil.isEmpty((Collection)depositBillIds)) {
            return;
        }
        LOG.info(DateUtils.formatString((Date)DateUtils.getCurrentDate(), (String)"yyyy-MM-dd") + "\u65e5\u6ee1\u8db3\u5b9a\u671f\u5b58\u6b3e\u81ea\u52a8\u7eed\u5b58\u7684\u5355\u636e\u6570\u6709\uff1a{}\u5f20", (Object)depositBillIds.size());
        OperationResult operResult = TmcOperateServiceHelper.execOperate((String)"redeposit", (String)"cim_deposit", (Object[])depositBillIds.toArray(), (OperateOption)OperateOption.create());
        LOG.info("\u5b9a\u671f\u5b58\u6b3e\u81ea\u52a8\u7eed\u5b58: " + (operResult.isSuccess() ? "\u6210\u529f" : "\u5931\u8d25\uff1b\u5931\u8d25\u4fe1\u606f" + operResult.getMessage()));
    }

    private QFilter[] getDepositFilter() {
        QFilter curDateFilter = new QFilter("expiredate", "=", (Object)DateUtils.getCurrentDate());
        QFilter expireRedepositFilter = new QFilter("expireredeposit", "in", (Object)new String[]{ExpireRedepositTypeEnum.PRINCIPALREDEPOSIT.getValue(), ExpireRedepositTypeEnum.PRINCIPALINTREDEPOSIT.getValue()});
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter bizStatusFilter = new QFilter("bizstatus", "in", (Object)new String[]{FinServiceStatusEnum.subscribe_done.getValue(), FinServiceStatusEnum.subscribe_part.getValue()});
        QFilter surpAmtFilter = new QFilter("surplusamount", ">", (Object)0);
        return new QFilter[]{curDateFilter, expireRedepositFilter, statusFilter, bizStatusFilter, surpAmtFilter};
    }
}

