/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.apply;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.enums.FinApplyTypeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinApplyPushValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sid = super.getSelector();
        sid.add("applytype");
        sid.add("lastamount");
        sid.add("billstatus");
        return sid;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject finApply = extendedDataEntity.getDataEntity();
            String applyType = finApply.getString("applytype");
            BigDecimal lastAmount = finApply.getBigDecimal("lastamount");
            if (FinApplyTypeEnum.REDEEM.getValue().equals(applyType)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u7c7b\u578b\u4e3a\u8d4e\u56de\u7533\u8bf7\uff0c\u4e0d\u5141\u8bb8\u7406\u8d22\u7533\u8d2d\u767b\u8bb0\uff01", (String)"FinApplyPushValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (lastAmount.compareTo(Constants.ZERO) <= 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5269\u4f59\u53ef\u7533\u8d2d\u91d1\u989d\u4e3a0\uff0c\u4e0d\u5141\u8bb8\u7406\u8d22\u7533\u8d2d\u767b\u8bb0\uff01", (String)"FinApplyPushValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
                continue;
            }
            QFilter qFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
            Object[] targetBills = TmcBotpHelper.getTargetBills((String)"cim_finapply", (Object)finApply.getPkValue(), (String)"cim_finsubscribe", (QFilter)qFilter);
            if (EmptyUtil.isNoEmpty((Object[])targetBills)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u4e0b\u5b58\u5728\u672a\u5904\u7406\u7684\u7533\u8d2d\u5355\uff0c\u4e0d\u5141\u8bb8\u7406\u8d22\u7533\u8d2d\u767b\u8bb0\uff01", (String)"FinApplyPushValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (BillStatusEnum.isAudit((String)finApply.getString("billstatus"))) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7406\u8d22\u7533\u8bf7\u5355\u624d\u5141\u8bb8\u8fdb\u884c\u7406\u8d22\u7533\u8d2d\u767b\u8bb0\u3002", (String)"FinApplyPushValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

