/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.apply;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.cim.common.helper.SuperMarketHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class FinApplySchemeSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObjectCollection cardEntrys;
            DynamicObject finApply = extendedDataEntity.getDataEntity();
            if (!finApply.getBoolean("inquiry") || EmptyUtil.isEmpty((DynamicObjectCollection)(cardEntrys = finApply.getDynamicObjectCollection("s_entry")))) continue;
            StringJoiner errorInfos = new StringJoiner("\n");
            StringJoiner prdErrInfo = new StringJoiner("\n");
            for (DynamicObject cardEntry : cardEntrys) {
                DynamicObject scheme = (DynamicObject)cardEntry.getDynamicObjectCollection("c_entry").get(0);
                Pair<Boolean, String> validateResult = this.validateMustInput(scheme);
                if (!((Boolean)validateResult.getKey()).booleanValue()) {
                    errorInfos.add(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8bf7\u6309\u8981\u6c42\u586b\u5199%2$s", (String)"FinApplySchemeSaveValidator_0", (String)"tmc-cim-business", (Object[])new Object[0]), scheme.getString("c_productno"), validateResult.getRight()));
                }
                this.validateProductCard(scheme, prdErrInfo);
            }
            if (errorInfos.length() > 0) {
                this.addMessage(extendedDataEntity, errorInfos.toString());
            }
            if (prdErrInfo.length() <= 0) continue;
            this.addErrorMessage(extendedDataEntity, prdErrInfo.toString());
        }
    }

    private Pair<Boolean, String> validateMustInput(DynamicObject scheme) {
        Map<String, String> mustInputProps = this.getMustInputProps();
        String redeemWay = scheme.getString("c_redeemway");
        boolean isSuccess = true;
        StringJoiner nullFeilds = new StringJoiner("\u3001");
        for (Map.Entry<String, String> propEntry : mustInputProps.entrySet()) {
            String propName = propEntry.getKey();
            Object propValue = scheme.get(propName);
            if (StringUtils.equals((CharSequence)"c_name", (CharSequence)propName)) {
                propValue = scheme.getString(propName);
            }
            if (EmptyUtil.isNoEmpty((Object)propValue)) continue;
            if (Arrays.asList("c_planrevenue", "c_intdate", "c_revenueproject").contains(propName)) {
                if (!StringUtils.equals((CharSequence)RedeemWayEnum.amount_redeem.getValue(), (CharSequence)redeemWay)) continue;
                nullFeilds.add(propEntry.getValue());
                isSuccess = false;
                continue;
            }
            nullFeilds.add(propEntry.getValue());
            isSuccess = false;
        }
        return Pair.of((Object)isSuccess, (Object)nullFeilds.toString());
    }

    private Map<String, String> getMustInputProps() {
        LinkedHashMap<String, String> propMap = new LinkedHashMap<String, String>(32);
        propMap.put("c_productno", ResManager.loadKDString((String)"\u201c\u7406\u8d22\u4ea7\u54c1\u4ee3\u7801\u201d", (String)"FinApplySchemeSaveValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_name", ResManager.loadKDString((String)"\u201c\u7406\u8d22\u4ea7\u54c1\u540d\u79f0\u201d", (String)"FinApplySchemeSaveValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_investvarieties", ResManager.loadKDString((String)"\u201c\u6295\u8d44\u54c1\u79cd\u201d", (String)"FinApplySchemeSaveValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_finorginfo", ResManager.loadKDString((String)"\u201c\u53d1\u884c\u673a\u6784\u201d", (String)"FinApplySchemeSaveValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_finaccount", ResManager.loadKDString((String)"\u201c\u7406\u8d22\u8d26\u6237\u201d", (String)"FinApplySchemeSaveValidator_5", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_valuedate", ResManager.loadKDString((String)"\u201c\u7406\u8d22\u5f00\u59cb\u65e5\u201d", (String)"FinApplySchemeSaveValidator_6", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_redeemway", ResManager.loadKDString((String)"\u201c\u8d4e\u56de\u65b9\u5f0f\u201d", (String)"FinApplySchemeSaveValidator_7", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_amount", ResManager.loadKDString((String)"\u201c\u7406\u8d22\u91d1\u989d\u201d", (String)"FinApplySchemeSaveValidator_8", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_planrevenue", ResManager.loadKDString((String)"\u201c\u9884\u8ba1\u6536\u76ca\u7387\uff08%\uff09\u201d", (String)"FinApplySchemeSaveValidator_11", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_revenuetype", ResManager.loadKDString((String)"\u201c\u6536\u76ca\u7c7b\u578b\u201d", (String)"FinApplySchemeSaveValidator_12", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_basis", ResManager.loadKDString((String)"\u201c\u8ba1\u606f\u57fa\u51c6\u201d", (String)"FinApplySchemeSaveValidator_13", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_intdate", ResManager.loadKDString((String)"\u201c\u8d77\u606f\u65e5\u201d", (String)"FinApplySchemeSaveValidator_14", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_bonusway", ResManager.loadKDString((String)"\u201c\u5206\u7ea2\u65b9\u5f0f\u201d", (String)"FinApplySchemeSaveValidator_15", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_revenueproject", ResManager.loadKDString((String)"\u201c\u6536\u76ca\u65b9\u6848\u201d", (String)"FinApplySchemeSaveValidator_16", (String)"tmc-cim-business", (Object[])new Object[0]));
        propMap.put("c_risklevel", ResManager.loadKDString((String)"\u201c\u98ce\u9669\u7b49\u7ea7\u201d", (String)"FinApplySchemeSaveValidator_17", (String)"tmc-cim-business", (Object[])new Object[0]));
        return propMap;
    }

    private void validateProductCard(DynamicObject finApply, StringJoiner prdErrInfo) {
        List errMsgs = SuperMarketHelper.getValidateProductCardMsgs((DynamicObject)finApply, (String)"c_");
        if (EmptyUtil.isNoEmpty((Object)errMsgs)) {
            for (String errMsg : errMsgs) {
                prdErrInfo.add(errMsg);
            }
        }
    }
}

