/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.apply;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.enums.DepositApplyTypeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class HugeDepositSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("accepttransfer");
        selector.add("intdate");
        selector.add("expiredate");
        selector.add("investvarieties");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject huge = extData.getDataEntity();
            if (!huge.getBoolean("accepttransfer")) continue;
            String currentEntity = huge.getDynamicObjectType().getName();
            if ("cim_deposit_apply".equals(currentEntity) && DepositApplyTypeEnum.RELEASE.getValue().equals(huge.getString("applytype"))) {
                this.validateRedeemDateWhenAcctTransfer(extData);
            }
            String investType = Optional.ofNullable(huge.getDynamicObject("investvarieties")).map(r -> r.getString("investtype")).orElse("");
            if (InvestTypeEnum.huge.getValue().equals(investType)) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u53d7/\u8f6c\u8ba9\u5f00\u542f\u65f6\uff0c\u5b58\u6b3e\u54c1\u79cd\u53ea\u80fd\u9009\u62e9\u5927\u989d\u5b58\u5355\u7c7b\u578b\u3002", (String)"HugeDepositSubmitValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }

    private void validateRedeemDateWhenAcctTransfer(ExtendedDataEntity extendData) {
        DynamicObject apply = extendData.getDataEntity();
        if (apply.getBoolean("accepttransfer")) {
            Date startDate = apply.getDate("intdate");
            Date redeemDate = apply.getDate("estimatedate");
            Date endDate = apply.getDate("expiredate");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, redeemDate, endDate})) {
                return;
            }
            if (redeemDate.compareTo(startDate) <= 0) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5927\u989d\u5b58\u5355\u8f6c\u8ba9\u65f6\uff0c\u9884\u8ba1\u89e3\u6d3b\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u8d77\u606f\u65e5\u3002", (String)"DepositApplySubmitValidator_18", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (redeemDate.compareTo(endDate) >= 0) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5927\u989d\u5b58\u5355\u8f6c\u8ba9\u65f6\uff0c\u9884\u8ba1\u89e3\u6d3b\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u5230\u671f\u65e5\u3002", (String)"DepositApplySubmitValidator_19", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
        }
    }
}

