/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.DepositApplyTypeEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;

public abstract class AbstractReDepositValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("srcdepositno");
        selector.add("billno");
        selector.add("expiredate");
        selector.add("expireredeposit");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        List billIdList = Arrays.stream(dataEntity).map(ExtendedDataEntity::getDataEntity).map(r -> r.getString("billno")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("srcdepositno", "in", billIdList);
        qFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()));
        String curEntity = dataEntity[0].getDataEntity().getDataEntityType().getName();
        DynamicObjectCollection redepositCols = QueryServiceHelper.query((String)curEntity, (String)"srcdepositno", (QFilter[])new QFilter[]{qFilter});
        Set srcNoSet = redepositCols.stream().map(r -> r.getString("srcdepositno")).collect(Collectors.toSet());
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject depositBill = extData.getDataEntity();
            if (srcNoSet.contains(depositBill.getString("billno"))) {
                this.addErrorMessage(extData, this.getExistReDepositBillTip());
            }
            String targetEntity = DepositHelper.getTargetEntity((String)curEntity);
            boolean isExists = DepositHelper.isExistsReleaseBill((String)curEntity, (Long)depositBill.getLong("id"), (String)targetEntity);
            if (isExists) {
                this.addErrorMessage(extData, this.getExistReleaseBillTip());
            }
            this.validateExistRleaseApply(extData, depositBill);
            this.validateAutoReDeposit(extData);
        }
    }

    private void validateExistRleaseApply(ExtendedDataEntity extData, DynamicObject depositBill) {
        QFilter applyQfilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        applyQfilter.and(new QFilter("applytype", "=", (Object)DepositApplyTypeEnum.RELEASE.getValue()));
        applyQfilter.and(new QFilter("deposit", "=", depositBill.getPkValue()));
        boolean exists = QueryServiceHelper.exists((String)"cim_deposit_apply", (QFilter[])new QFilter[]{applyQfilter});
        if (exists) {
            this.addErrorMessage(extData, this.getExistReleaseApplyTip());
        }
    }

    protected void validateAutoReDeposit(ExtendedDataEntity extData) {
    }

    abstract String getExistReDepositBillTip();

    abstract String getExistReleaseBillTip();

    abstract String getExistReleaseApplyTip();
}

