/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.AgreeDepositStatusEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AgreeDepositAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bankacct");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        HashMap<Long, List> idMap = new HashMap<Long, List>();
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject agreeBill = extData.getDataEntity();
            Long bankAcctId = agreeBill.getDynamicObject("bankacct").getLong("id");
            List curBillIds = idMap.computeIfAbsent(bankAcctId, k -> new ArrayList());
            curBillIds.add(agreeBill.getLong("id"));
        }
        Set bankIds = Arrays.stream(dataEntity).map(r -> r.getDataEntity()).map(r -> r.getDynamicObject("bankacct")).map(r -> r.getPkValue()).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("bankacct", "in", bankIds);
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilter.and(new QFilter("status", "=", (Object)AgreeDepositStatusEnum.NORMAL.getValue()));
        DynamicObjectCollection existAgree = QueryServiceHelper.query((String)"cim_agreement_deposit", (String)"id,bankacct,billno", (QFilter[])new QFilter[]{qFilter});
        Map<Long, Long> bankToAgreeMap = existAgree.stream().collect(Collectors.toMap(r -> r.getLong("bankacct"), r -> r.getLong("id")));
        Map<String, Long> billNoMap = existAgree.stream().collect(Collectors.toMap(r -> r.getString("billno"), r -> r.getLong("id")));
        for (ExtendedDataEntity extData : dataEntity) {
            String srcDepositNo;
            DynamicObject agreeBill = extData.getDataEntity();
            Long bankId = Optional.ofNullable(agreeBill.getDynamicObject("bankacct")).map(r -> r.getLong("id")).orElse(0L);
            List doingAgreeIds = (List)idMap.get(bankId);
            if (doingAgreeIds.size() > 1 && doingAgreeIds.indexOf(agreeBill.getLong("id")) > 0) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u534f\u5b9a\u8d26\u53f7\u7684\u534f\u5b9a\u5b58\u6b3e\u3002", (String)"AgreeDepositAuditValidator_0", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (bankToAgreeMap.size() <= 0 || !EmptyUtil.isNoEmpty((Long)bankToAgreeMap.get(bankId)) || !EmptyUtil.isEmpty((String)(srcDepositNo = agreeBill.getString("srcdepositno"))) && !EmptyUtil.isEmpty((Long)billNoMap.get(srcDepositNo))) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u534f\u5b9a\u8d26\u53f7\u7684\u534f\u5b9a\u5b58\u6b3e\u3002", (String)"AgreeDepositAuditValidator_0", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

