/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.AgreeDepositStatusEnum;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AgreeDepositAutoReDepositValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("autoredeposit");
        selector.add("status");
        selector.add("enddate");
        selector.add("billno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject agreeDeposit = extData.getDataEntity();
            if (!StringUtils.equals((CharSequence)BillStatusEnum.AUDIT.getValue(), (CharSequence)agreeDeposit.getString("billstatus"))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u7684\u5355\u636e\u624d\u5141\u8bb8\u7eed\u671f\u3002", (String)"AgreeDepositAutoReDepositValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (!agreeDeposit.getBoolean("autoredeposit")) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u53ea\u6709\u5230\u671f\u81ea\u52a8\u5ef6\u671f\u4e3a\u662f\u7684\u5355\u636e\u624d\u5141\u8bb8\u7eed\u671f\u3002", (String)"AgreeDepositAutoReDepositValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (!AgreeDepositStatusEnum.isNormal((String)agreeDeposit.getString("status"))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u53ea\u6709\u534f\u8bae\u72b6\u6001\u4e3a\u6b63\u5e38\u7684\u5355\u636e\u624d\u5141\u8bb8\u7eed\u671f\u3002", (String)"AgreeDepositAutoReDepositValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty((Object)agreeDeposit.getDate("enddate"))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u53ea\u6709\u534f\u8bae\u7ed3\u675f\u65e5\u671f\u4e0d\u4e3a\u7a7a\u7684\u5355\u636e\u624d\u5141\u8bb8\u7eed\u671f\u3002", (String)"AgreeDepositAutoReDepositValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (!this.isExistsDoingRedepositBill(agreeDeposit)) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5728\u9014\u7684\u7eed\u671f\u5355\u3002", (String)"AgreeDepositAutoReDepositValidator_5", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }

    private boolean isExistsDoingRedepositBill(DynamicObject agreeDeposit) {
        QFilter qFilter = new QFilter("srcdepositno", "=", (Object)agreeDeposit.getString("billno"));
        qFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilter.and(new QFilter("status", "=", (Object)AgreeDepositStatusEnum.NORMAL.getValue()));
        return QueryServiceHelper.exists((String)"cim_agreement_deposit", (QFilter[])new QFilter[]{qFilter});
    }
}

