/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.enums.DepositApplyTypeEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositApplyPushScValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("finorginfo");
        selector.add("applytype");
        selector.add("deposit");
        selector.add("releaseamount");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            String applyType;
            DynamicObject bizDealBill;
            DynamicObject apply = extData.getDataEntity();
            if (!BillStatusEnum.isAudit((String)apply.getString("billstatus"))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u5ba1\u6838\u7684\u5b58\u6b3e\u4e1a\u52a1\u7533\u8bf7\u5355\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DepositApplyList_9", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            }
            if (!DepositHelper.isSettleCenterBill((DynamicObject)apply)) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5b58\u6b3e\u673a\u6784\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\u7684\u5b58\u6b3e\u4e1a\u52a1\u7533\u8bf7\u5355\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DepositApplyList_10", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(bizDealBill = TmcBotpHelper.getTargetBill((String)"cim_deposit_apply", (Object)apply.getPkValue(), (String)"ifm_bizdealbill_deposit"))) && !StringUtils.equals((CharSequence)"D", (CharSequence)bizDealBill.getString("bizstatus"))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8be5\u5b58\u6b3e\u4e1a\u52a1\u7533\u8bf7\u5355\u5df2\u4e0b\u63a8\u5185\u90e8\u5b58\u6b3e\u53d7\u7406\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DepositApplyList_11", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            }
            if (!StringUtils.equals((CharSequence)(applyType = apply.getString("applytype")), (CharSequence)DepositApplyTypeEnum.RELEASE.getValue())) continue;
            DynamicObject deposit = apply.getDynamicObject("deposit");
            BigDecimal surPlusAmt = deposit.getBigDecimal("surplusamount");
            BigDecimal releaseAmt = apply.getBigDecimal("releaseamount");
            if (releaseAmt.compareTo(surPlusAmt) <= 0) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8be5\u5b58\u6b3e\u4e1a\u52a1\u7533\u8bf7\u7684\u89e3\u6d3b\u91d1\u989d\u5927\u4e8e\u53ef\u89e3\u6d3b\u91d1\u989d\uff0c\u63d0\u4ea4\u7ed3\u7b97\u4e2d\u5fc3\u5931\u8d25\u3002", (String)"DepositApplyList_12", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
        }
    }
}

