/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.DepositApplyTypeEnum;
import kd.tmc.cim.common.enums.ReleaseTypeEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositApplySubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("estimatedate");
        selector.add("releaseamount");
        selector.add("deposit");
        selector.add("applytype");
        selector.add("expireredeposit");
        selector.add("investvarieties");
        selector.add("releasetype");
        selector.add("prenoticeday");
        selector.add("term");
        selector.add("deadline");
        selector.add("tradechannel");
        selector.add("inquiry");
        selector.add("entry");
        selector.add("s_entry");
        selector.add("rangemin");
        selector.add("rangemax");
        selector.add("interestrate");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendData : dataEntity) {
            DynamicObject depositApplyBill = extendData.getDataEntity();
            if (DepositApplyTypeEnum.DEPOSIT.getValue().equals(depositApplyBill.getString("applytype"))) {
                this.doDepositValidate(extendData);
                this.validateApplyAmt(extendData, depositApplyBill);
                if (depositApplyBill.getBoolean("inquiry")) {
                    DynamicObjectCollection schemeCards = depositApplyBill.getDynamicObjectCollection("s_entry");
                    DynamicObjectCollection entryList = depositApplyBill.getDynamicObjectCollection("entry");
                    if (!CollectionUtils.isEmpty((Collection)schemeCards) || !CollectionUtils.isEmpty((Collection)entryList)) continue;
                    this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b58\u6b3e\u65b9\u6848\u4fe1\u606f\u3002", (String)"DepositApplySubmitValidator_5", (String)"tmc-cim-business", (Object[])new Object[0]));
                    continue;
                }
            } else if (DepositApplyTypeEnum.RELEASE.getValue().equals(depositApplyBill.getString("applytype"))) {
                this.doReleaseValidate(extendData);
                this.validateExistDoingBill(extendData);
            } else if (DepositApplyTypeEnum.SUBSIST.getValue().equals(depositApplyBill.getString("applytype"))) {
                this.validateExpireRedeposit(extendData);
                this.validateExistDoingBill(extendData);
            }
            this.validateRangeRate(extendData, depositApplyBill);
        }
    }

    private void doDepositValidate(ExtendedDataEntity extendData) {
        this.validatePrenoticeDay(extendData);
        this.validateExpireRedeposit(extendData);
    }

    private void doReleaseValidate(ExtendedDataEntity extendData) {
        DynamicObject depositApplyBill = extendData.getDataEntity();
        DynamicObject depositBill = depositApplyBill.getDynamicObject("deposit");
        this.checkReleaseAmount(extendData, depositApplyBill, depositBill);
        this.checkEstimateDate(extendData, depositApplyBill, depositBill);
        this.checkDepositBill(extendData, depositBill);
        this.validateExpireRedeposit(extendData);
    }

    private void checkDepositBill(ExtendedDataEntity extendData, DynamicObject depositBill) {
        if (EmptyUtil.isNoEmpty((DynamicObject)depositBill)) {
            QFilter qFilter = new QFilter("finbillno", "=", depositBill.getPkValue());
            qFilter.and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
            boolean exists = TmcDataServiceHelper.exists((String)CimEntityEnum.cim_release.getValue(), (QFilter[])qFilter.toArray());
            if (exists) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5b58\u6b3e\u5355\u4e0b\u5b58\u5728\u6d41\u7a0b\u4e2d\u7684\u89e3\u6d3b\u5355\u8bb0\u5f55\u672a\u5904\u7406\uff0c\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"DepositApplySubmitValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
        }
    }

    private void checkReleaseAmount(ExtendedDataEntity extendData, DynamicObject depositApplyBill, DynamicObject depositBill) {
        BigDecimal surplusAmount;
        BigDecimal releaseAmount = depositApplyBill.getBigDecimal("releaseamount");
        if (BigDecimal.ZERO.compareTo(releaseAmount) >= 0) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u89e3\u6d3b\u672c\u91d1\u91d1\u989d\u9700\u5927\u4e8e0\u3002", (String)"DepositApplySubmitValidator_6", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)depositBill) && releaseAmount.compareTo(surplusAmount = depositBill.getBigDecimal("surplusamount")) > 0) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u89e3\u6d3b\u672c\u91d1\u91d1\u989d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u6240\u9009\u62e9\u5b58\u6b3e\u5355\u7684\u5269\u4f59\u91d1\u989d\u3002", (String)"DepositApplySubmitValidator_7", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }

    private void checkEstimateDate(ExtendedDataEntity extendData, DynamicObject depositApplyBill, DynamicObject depositBill) {
        Date estimateDate = depositApplyBill.getDate("estimatedate");
        Date intDate = depositBill.getDate("intdate");
        if (EmptyUtil.isNoEmpty((Object)estimateDate) && EmptyUtil.isNoEmpty((Object)intDate) && estimateDate.compareTo(intDate) < 0) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u9884\u8ba1\u89e3\u6d3b\u65e5\u671f\u9700\u5927\u4e8e\u7b49\u4e8e\u6240\u9009\u5b58\u6b3e\u5355\u7684\u5b58\u6b3e\u8d77\u606f\u65e5\u3002", (String)"DepositApplySubmitValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }

    private void validateExpireRedeposit(ExtendedDataEntity extendData) {
        boolean isMustInput;
        DynamicObject depositApply = extendData.getDataEntity();
        String expireRedeposit = depositApply.getString("expireredeposit");
        if (EmptyUtil.isNoEmpty((String)expireRedeposit)) {
            return;
        }
        String applyType = depositApply.getString("applytype");
        String releaseType = depositApply.getString("releasetype");
        DynamicObject investVarieties = depositApply.getDynamicObject("investvarieties");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{investVarieties, applyType, releaseType})) {
            return;
        }
        String investType = investVarieties.getString("investtype");
        boolean bl = isMustInput = InvestTypeEnum.isFixed((String)investType) && (StringUtils.equals((CharSequence)applyType, (CharSequence)DepositApplyTypeEnum.DEPOSIT.getValue()) || StringUtils.equals((CharSequence)applyType, (CharSequence)DepositApplyTypeEnum.SUBSIST.getValue()) || StringUtils.equals((CharSequence)applyType, (CharSequence)DepositApplyTypeEnum.RELEASE.getValue()) && StringUtils.equals((CharSequence)releaseType, (CharSequence)ReleaseTypeEnum.expire.getValue()));
        if (isMustInput) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5230\u671f\u7eed\u5b58\u201d\u5b57\u6bb5\u3002", (String)"DepositApplySubmitValidator_8", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }

    private void validatePrenoticeDay(ExtendedDataEntity extendData) {
        DynamicObject depositApply = extendData.getDataEntity();
        DynamicObject investVarieties = depositApply.getDynamicObject("investvarieties");
        if (EmptyUtil.isEmpty((DynamicObject)investVarieties)) {
            return;
        }
        String investType = investVarieties.getString("investtype");
        String preNoticeDay = depositApply.getString("prenoticeday");
        if (EmptyUtil.isEmpty((String)preNoticeDay) && InvestTypeEnum.isNotice((String)investType)) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u63d0\u524d\u901a\u77e5\u5929\u6570\u201d\u5b57\u6bb5\u3002", (String)"DepositApplySubmitValidator_9", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
        if (InvestTypeEnum.isFixed((String)investType)) {
            String term = depositApply.getString("term");
            String deadLine = depositApply.getString("deadline");
            String tradechannel = depositApply.getString("tradechannel");
            if (!StringUtils.equals((CharSequence)tradechannel, (CharSequence)TradeChannelEnum.ONLINE.getValue()) && EmptyUtil.isEmpty((String)term) || StringUtils.equals((CharSequence)tradechannel, (CharSequence)TradeChannelEnum.ONLINE.getValue()) && EmptyUtil.isEmpty((String)deadLine)) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u671f\u9650\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositDealSubmitValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
        }
    }

    private void validateApplyAmt(ExtendedDataEntity extendData, DynamicObject depositApplyBill) {
        String applyType = depositApplyBill.getString("applytype");
        if (!StringUtils.equals((CharSequence)DepositApplyTypeEnum.DEPOSIT.getValue(), (CharSequence)applyType) || depositApplyBill.getBoolean("inquiry")) {
            return;
        }
        BigDecimal amt = depositApplyBill.getBigDecimal("amount");
        if (BigDecimal.ZERO.compareTo(amt) >= 0) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5b58\u6b3e\u91d1\u989d\u9700\u5927\u4e8e0\u3002", (String)"DepositApplySubmitValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }

    private void validateExistDoingBill(ExtendedDataEntity extendData) {
        QFilter srcNumFilter;
        QFilter isRedepositFilter;
        QFilter depositFilterRe;
        QFilter subsistFilter;
        QFilter depositIdFilter;
        DynamicObject depositApply = extendData.getDataEntity();
        DynamicObject depositBill = depositApply.getDynamicObject("deposit");
        Object depositId = depositBill.getPkValue();
        QFilter statusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter applyIdFilter = new QFilter("id", "!=", depositApply.getPkValue());
        QFilter releTypeFilter = new QFilter("applytype", "=", (Object)DepositApplyTypeEnum.RELEASE.getValue());
        boolean exists = QueryServiceHelper.exists((String)"cim_deposit_apply", (QFilter[])new QFilter[]{statusFilter, releTypeFilter, depositIdFilter = new QFilter("deposit", "=", depositId), applyIdFilter});
        if (exists) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5b58\u5728\u5728\u9014\u7684\u89e3\u6d3b\u7533\u8bf7\u5355\u3002", (String)"DepositApplySubmitValidator_10", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
        if (exists = QueryServiceHelper.exists((String)"cim_deposit_apply", (QFilter[])new QFilter[]{statusFilter, subsistFilter = new QFilter("applytype", "=", (Object)DepositApplyTypeEnum.SUBSIST.getValue()), depositIdFilter, applyIdFilter})) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5b58\u5728\u5728\u9014\u7684\u7eed\u5b58\u7533\u8bf7\u5355\u3002", (String)"DepositApplySubmitValidator_11", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
        if (exists = QueryServiceHelper.exists((String)"cim_release", (QFilter[])new QFilter[]{statusFilter, depositFilterRe = new QFilter("finbillno", "=", depositId)})) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5b58\u5728\u5728\u9014\u7684\u89e3\u6d3b\u5355\u3002", (String)"DepositApplySubmitValidator_12", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
        if (exists = QueryServiceHelper.exists((String)"cim_deposit", (QFilter[])new QFilter[]{statusFilter, isRedepositFilter = new QFilter("isredepositgenerate", "=", (Object)Boolean.TRUE), srcNumFilter = new QFilter("srcdepositno", "=", (Object)depositBill.getString("number"))})) {
            Long invarId = Optional.ofNullable(depositBill.getDynamicObject("investvarieties")).map(r -> r.getLong("id")).orElse(0L);
            DynamicObject invarDyn = QueryServiceHelper.queryOne((String)"cim_investvarieties", (String)"investtype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)invarId)});
            String tips = EmptyUtil.isNoEmpty((DynamicObject)invarDyn) && InvestTypeEnum.isNotice((String)invarDyn.getString("investtype")) ? ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5b58\u5728\u5728\u9014\u7684\u8f6c\u5b58\u5355\u3002", (String)"DepositApplySubmitValidator_14", (String)"tmc-cim-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5b58\u5728\u5728\u9014\u7684\u7eed\u5b58\u5355\u3002", (String)"DepositApplySubmitValidator_13", (String)"tmc-cim-business", (Object[])new Object[0]);
            this.addErrorMessage(extendData, tips);
        }
    }

    private void validateRangeRate(ExtendedDataEntity extendData, DynamicObject depositApply) {
        List msgList = DepositHelper.validateRangeRate((DynamicObject)depositApply, (boolean)false);
        if (EmptyUtil.isNoEmpty((Object)msgList)) {
            for (String msg : msgList) {
                this.addErrorMessage(extendData, msg);
            }
        }
    }
}

