/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.util.DateUtils;

public class DepositDealAutoRevenueValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("bizstatus");
        selector.add("lastrevenuedate");
        selector.add("intdate");
        selector.add("revenue_entry.revenuedate");
        selector.add("finorginfo");
        selector.add("investvarieties");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObjectCollection rows;
            long count;
            Date currentDate;
            Date lastRevDate;
            DynamicObject deposit = extData.getDataEntity();
            String billStatus = deposit.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u9700\u662f\u5df2\u5ba1\u6838\u7684\u3002", (String)"DepositDealAutoRevenueValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            String bizStatus = deposit.getString("bizstatus");
            if (!FinServiceStatusEnum.subscribe_done.getValue().equals(bizStatus) && !FinServiceStatusEnum.subscribe_part.getValue().equals(bizStatus)) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5b58\u6b3e\u4e1a\u52a1\u72b6\u6001\u5e94\u4e3a\u5df2\u5b58\u6b3e\u6216\u5df2\u90e8\u5206\u89e3\u6d3b\u3002", (String)"DepositDealAutoRevenueValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if ((lastRevDate = DepositHelper.getIntCalcStartDate((DynamicObject)deposit)).compareTo(DateUtils.getNextDay((Date)(currentDate = DateUtils.getCurrentDate()), (int)-1)) > 0) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u4e0a\u6b21\u6536\u76ca\u65e5\u671f\uff08\u6216\u5b58\u6b3e\u8d77\u606f\u65e5\uff09\u5e94\u65e9\u4e8e\u4e8b\u52a1\u6267\u884c\u65e5\u671f\u7684\u524d\u4e00\u5929\u3002", (String)"DepositDealAutoRevenueValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if ((count = (rows = deposit.getDynamicObjectCollection("revenue_entry")).stream().filter(r -> r.getDate("revenuedate").compareTo(currentDate) == 0).count()) <= 0L) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u6536\u76ca\u8ba1\u5212.\u9884\u8ba1\u6536\u76ca\u65e5\u671f\u5176\u4e2d\u4e00\u6761\u9700\u662f\u7b49\u4e8e\u4e8b\u52a1\u6267\u884c\u7684\u65e5\u671f\u3002", (String)"DepositDealAutoRevenueValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            this.validateByCurrentEntity(extData, deposit);
        }
    }

    private void validateByCurrentEntity(ExtendedDataEntity extData, DynamicObject deposit) {
        String entityName;
        String investType = Optional.ofNullable(deposit.getDynamicObject("investvarieties")).map(r -> r.getString("investtype")).orElse("");
        switch (entityName = deposit.getDynamicObjectType().getName()) {
            case "cim_deposit": {
                if (DepositHelper.isSettleCenterBill((DynamicObject)deposit)) {
                    this.addErrorMessage(extData, ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u6570\u636e\u3002\u6b64\u5904\u4e0d\u5141\u8bb8\u81ea\u52a8\u751f\u6210\u6536\u76ca\u3002", (String)"DepositDealAutoRevenueValidator_5", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                if (InvestTypeEnum.isFixed((String)investType)) break;
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u975e\u5b9a\u671f\u5b58\u6b3e\u6570\u636e\uff0c\u6b64\u5904\u4e0d\u5141\u8bb8\u4f5c\u81ea\u52a8\u6536\u76ca\u3002", (String)"DepositDealAutoRevenueValidator_6", (String)"tmc-cim-business", (Object[])new Object[0]));
                break;
            }
            case "cim_noticedeposit": {
                if (DepositHelper.isSettleCenterBill((DynamicObject)deposit)) {
                    this.addErrorMessage(extData, ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u6570\u636e\u3002\u6b64\u5904\u4e0d\u5141\u8bb8\u81ea\u52a8\u751f\u6210\u6536\u76ca\u3002", (String)"DepositDealAutoRevenueValidator_5", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                if (InvestTypeEnum.isNotice((String)investType)) break;
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u975e\u901a\u77e5\u5b58\u6b3e\u6570\u636e\uff0c\u6b64\u5904\u4e0d\u5141\u8bb8\u4f5c\u81ea\u52a8\u6536\u76ca\u3002", (String)"DepositDealAutoRevenueValidator_7", (String)"tmc-cim-business", (Object[])new Object[0]));
                break;
            }
            case "ifm_deposit": {
                if (!DepositHelper.isSettleCenterBill((DynamicObject)deposit)) {
                    this.addErrorMessage(extData, ResManager.loadKDString((String)"\u975e\u7ed3\u7b97\u4e2d\u5fc3\u6570\u636e\uff0c\u6b64\u5904\u4e0d\u5141\u8bb8\u81ea\u52a8\u6536\u76ca\u3002", (String)"DepositDealAutoRevenueValidator_8", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                if (InvestTypeEnum.isFixed((String)investType)) break;
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u975e\u5b9a\u671f\u5b58\u6b3e\u6570\u636e\uff0c\u6b64\u5904\u4e0d\u5141\u8bb8\u4f5c\u81ea\u52a8\u6536\u76ca\u3002", (String)"DepositDealAutoRevenueValidator_6", (String)"tmc-cim-business", (Object[])new Object[0]));
                break;
            }
            case "ifm_notice_deposit": {
                if (!DepositHelper.isSettleCenterBill((DynamicObject)deposit)) {
                    this.addErrorMessage(extData, ResManager.loadKDString((String)"\u975e\u7ed3\u7b97\u4e2d\u5fc3\u6570\u636e\uff0c\u6b64\u5904\u4e0d\u5141\u8bb8\u81ea\u52a8\u6536\u76ca\u3002", (String)"DepositDealAutoRevenueValidator_8", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                if (InvestTypeEnum.isNotice((String)investType)) break;
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u975e\u901a\u77e5\u5b58\u6b3e\u6570\u636e\uff0c\u6b64\u5904\u4e0d\u5141\u8bb8\u4f5c\u81ea\u52a8\u6536\u76ca\u3002", (String)"DepositDealAutoRevenueValidator_7", (String)"tmc-cim-business", (Object[])new Object[0]));
                break;
            }
            default: {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u7591\u662f\u810f\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepositDealAutoRevenueValidator_9", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
        }
    }
}

