/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.BebankStatusEnum;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositDealPushRevenueValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("lastrevenuedate");
        selector.add("intdate");
        selector.add("bizstatus");
        selector.add("tradechannel");
        selector.add("bebankstatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        List ids = Arrays.stream(dataEntity).map(d -> d.getDataEntity().getPkValue()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("sourcebillid", "in", ids);
        qFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()));
        DynamicObjectCollection dptRevenues = QueryServiceHelper.query((String)"cim_dptrevenue", (String)"sourcebillid", (QFilter[])qFilter.toArray());
        Set sourceBillIds = dptRevenues.stream().map(d -> d.getLong("sourcebillid")).collect(Collectors.toSet());
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject deposit = extData.getDataEntity();
            if (!this.validateDepositBizStatus(extData, deposit)) continue;
            if (sourceBillIds.contains(deposit.getLong("id"))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u8be5\u5b58\u6b3e\u5355\u5b58\u5728\u6682\u5b58\u6216\u5df2\u63d0\u4ea4\u7684\u6536\u76ca\u5355\uff0c\u8bf7\u5148\u5220\u9664\u6216\u5ba1\u6838\u3002", (String)"DepositDealPushRevenueValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
                continue;
            }
            this.validateIsEqualsIntStartDate(extData, deposit);
        }
    }

    private boolean validateIsEqualsIntStartDate(ExtendedDataEntity extData, DynamicObject deposit) {
        Date maxStartDate;
        Date startDate;
        Map opMap = this.getOption().getVariables();
        String startDateStr = (String)opMap.get("startdate");
        if (EmptyUtil.isNoEmpty((String)startDateStr) && (startDate = DateUtils.stringToDate((String)startDateStr, (String)"yyyy-MM-dd")).compareTo(maxStartDate = DepositHelper.getIntCalcStartDate((DynamicObject)deposit)) != 0) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5b58\u6b3e\u5355\u7684\u6536\u76ca\u8ba1\u7b97\u5f00\u59cb\u65e5\u5df2\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u5b58\u6b3e\u6536\u76ca\u6279\u91cf\u5904\u7406\u5355\u3002", (String)"DepositDealPushRevenueValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateDepositBizStatus(ExtendedDataEntity extData, DynamicObject deposit) {
        Map opMap = this.getOption().getVariables();
        String bizStatus = deposit.getString("bizstatus");
        String constVar = (String)opMap.get("const_operate_var");
        if (EmptyUtil.isNoEmpty((String)constVar) && "fromRedeposit".equals(constVar)) {
            return true;
        }
        if (!FinServiceStatusEnum.isSubscribeDone((String)bizStatus) && !FinServiceStatusEnum.isSubscribePart((String)bizStatus) && !FinServiceStatusEnum.isSubscribeNorevenue((String)bizStatus) && EmptyUtil.isEmpty((String)((String)opMap.get("pass_pushrevenue_validate")))) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u5b58\u6b3e\u3001\u5df2\u90e8\u5206\u89e3\u6d3b\u6216\u5df2\u89e3\u6d3b\u672a\u6536\u76ca\u4e1a\u52a1\u72b6\u6001\u7684\u5b9a\u671f\uff08\u901a\u77e5\uff09\u5b58\u6b3e\u5355\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DepositDealPushRevenueValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
            return false;
        }
        String tradeChannel = deposit.getString("tradechannel");
        if (StringUtils.equals((CharSequence)TradeChannelEnum.ONLINE.getValue(), (CharSequence)tradeChannel) && !StringUtils.equals((CharSequence)BebankStatusEnum.TS.getValue(), (CharSequence)deposit.getString("bebankstatus"))) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5982\u679c\u4ea4\u6613\u6e20\u9053\u4e3a\u94f6\u4f01\u76f4\u8054\uff0c\u76f4\u8054\u63d0\u4ea4\u72b6\u6001\u9700\u8981\u4e3a\u4ea4\u6613\u6210\u529f\u624d\u80fd\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DepositDealList_8", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

