/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositDealSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("investvarieties");
        selector.add("term");
        selector.add("expiredate");
        selector.add("prenoticeday");
        selector.add("interesttype");
        selector.add("interestrate");
        selector.add("referencerate");
        selector.add("tradechannel");
        selector.add("intdate");
        selector.add("demandrate");
        selector.add("sourcebilltype");
        selector.add("apply");
        selector.add("interestrate");
        selector.add("deadline");
        selector.add("finorginfo");
        selector.add("srcdepositno");
        selector.add("srcexpireredeposit");
        selector.add("rangemin");
        selector.add("rangemax");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntity.length);
        for (ExtendedDataEntity extendData : dataEntity) {
            DynamicObject depositBill = extendData.getDataEntity();
            if (!this.checkMustInputByTradeChannel(extendData)) continue;
            this.checkMustInputByInvestvarieties(extendData, depositBill);
            if (!this.checkMustInputByInterestType(extendData, depositBill) || !this.checkSrcReWhenRedeposit(extendData) || !this.checkExistsReleaseBill(extendData, depositBill) || !this.validateRangeRate(extendData, depositBill)) continue;
            dataEntityList.add(extendData);
        }
        this.checkExistsReDepositBill(dataEntityList);
    }

    private boolean checkMustInputByInterestType(ExtendedDataEntity extendData, DynamicObject depositBill) {
        DynamicObject referRate;
        String intType = depositBill.getString("interesttype");
        if (InterestTypeEnum.isFixed((String)intType)) {
            BigDecimal depositRate = depositBill.getBigDecimal("interestrate");
            String tradechannel = depositBill.getString("tradechannel");
            if (EmptyUtil.isEmpty((BigDecimal)depositRate) && !TradeChannelEnum.isOnLine((String)tradechannel)) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5b58\u6b3e\u5229\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositDealSubmitValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
                return false;
            }
        } else if (StringUtils.equals((CharSequence)InterestTypeEnum.FLOAT.getValue(), (CharSequence)intType) && EmptyUtil.isEmpty((DynamicObject)(referRate = depositBill.getDynamicObject("referencerate")))) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u53c2\u8003\u5229\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositDealSubmitValidator_5", (String)"tmc-cim-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void checkMustInputByInvestvarieties(ExtendedDataEntity extendData, DynamicObject depositBill) {
        Optional.ofNullable(depositBill.getDynamicObject("investvarieties")).map(r -> r.getString("investtype")).ifPresent(investType -> {
            if (InvestTypeEnum.isNotice((String)investType)) {
                String preNoticeDay = depositBill.getString("prenoticeday");
                if (EmptyUtil.isEmpty((String)preNoticeDay)) {
                    this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u63d0\u524d\u901a\u77e5\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositDealSubmitValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
            } else if (InvestTypeEnum.isFixed((String)investType)) {
                String term = depositBill.getString("term");
                String deadLine = depositBill.getString("deadline");
                String tradechannel = depositBill.getString("tradechannel");
                if (!StringUtils.equals((CharSequence)tradechannel, (CharSequence)TradeChannelEnum.ONLINE.getValue()) && EmptyUtil.isEmpty((String)term) || StringUtils.equals((CharSequence)tradechannel, (CharSequence)TradeChannelEnum.ONLINE.getValue()) && EmptyUtil.isEmpty((String)deadLine)) {
                    this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u671f\u9650\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositDealSubmitValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
                }
                if (!StringUtils.equals((CharSequence)tradechannel, (CharSequence)TradeChannelEnum.ONLINE.getValue())) {
                    Date intDate;
                    Date expireDate = depositBill.getDate("expiredate");
                    if (EmptyUtil.isEmpty((Object)expireDate)) {
                        this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5230\u671f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositDealSubmitValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
                    }
                    if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate = depositBill.getDate("intdate"), expireDate}) && expireDate.compareTo(intDate) <= 0) {
                        this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5230\u671f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5b58\u6b3e\u8d77\u606f\u65e5\u671f\u3002", (String)"DepositDealSubmitValidator_6", (String)"tmc-cim-business", (Object[])new Object[0]));
                    }
                }
            }
        });
    }

    private boolean checkMustInputByTradeChannel(ExtendedDataEntity extendData) {
        DynamicObject depositBill = extendData.getDataEntity();
        if (!TradeChannelEnum.isOnLine((String)depositBill.getString("tradechannel")) && EmptyUtil.isEmpty((Object)depositBill.getDate("intdate"))) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5b58\u6b3e\u8d77\u606f\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositDealSubmitValidator_9", (String)"tmc-cim-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkExistsReleaseBill(ExtendedDataEntity extendData, DynamicObject depositBill) {
        boolean isExists;
        Map varMap = this.getOption().getVariables();
        if (!varMap.containsKey("skipredepositvalidate") && (isExists = DepositHelper.isExistsReleaseBill((DynamicObject)depositBill))) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u7eed\u5b58\u5931\u8d25\uff0c\u5b58\u5728\u5728\u9014\u7684\u89e3\u6d3b\u5355\u3002", (String)"FixedDepositReDepositValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private List<ExtendedDataEntity> checkExistsReDepositBill(List<ExtendedDataEntity> dataEntities) {
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        List deposits = dataEntities.stream().map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Map map = DepositHelper.validateRedeposit(deposits);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject deposit = dataEntity.getDataEntity();
            long depositId = deposit.getLong("id");
            Boolean isTrue = (Boolean)map.get(depositId);
            if (isTrue != null && !isTrue.booleanValue()) {
                String entityName = deposit.getDynamicObjectType().getName();
                if ("cim_deposit".equals(entityName)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5728\u9014\u7684\u7eed\u5b58\u5355\u3002", (String)"DepositDealSaveValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
                    continue;
                }
                if (!"cim_noticedeposit".equals(entityName)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5728\u9014\u7684\u8f6c\u5b58\u5355\u3002", (String)"DepositDealSaveValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private boolean checkSrcReWhenRedeposit(ExtendedDataEntity extendData) {
        DynamicObject redepositBill = extendData.getDataEntity();
        if (!redepositBill.getBoolean("isredepositgenerate")) {
            return true;
        }
        if (EmptyUtil.isEmpty((String)redepositBill.getString("srcexpireredeposit"))) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u6e90\u5355\u5230\u671f\u7eed\u5b58\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositDealSaveValidator_5", (String)"tmc-cim-business", (Object[])new Object[0]));
            return false;
        }
        BigDecimal srcInterest = redepositBill.getBigDecimal("srcinterest");
        if (srcInterest.compareTo(BigDecimal.ZERO) <= 0) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u4e0a\u671f\u5229\u606f\u9700\u5927\u4e8e0\u3002", (String)"DepositDealSaveValidator_7", (String)"tmc-cim-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateRangeRate(ExtendedDataEntity extendData, DynamicObject depositBill) {
        List msgList = DepositHelper.validateRangeRate((DynamicObject)depositBill, (boolean)false);
        if (EmptyUtil.isNoEmpty((Object)msgList)) {
            this.addErrorMessage(extendData, String.join((CharSequence)";", msgList));
            return false;
        }
        if (!InterestTypeEnum.isRange((String)depositBill.getString("interesttype"))) {
            return true;
        }
        BigDecimal rangeMin = depositBill.getBigDecimal("rangemin");
        BigDecimal rangeMax = depositBill.getBigDecimal("rangemax");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{rangeMin, rangeMax})) {
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5229\u7387\u533a\u95f4(%)\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DepositDealSaveValidator_8", (String)"tmc-cim-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

