/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositIntPreAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcebillid");
        selector.add("prestenddate");
        selector.add("operatetype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            long depositBillId;
            DynamicObject depositBill;
            DynamicObject intPreBill = extData.getDataEntity();
            if (StringUtils.equals((CharSequence)PreIntOperateTypeEnum.REVERSEINT.getValue(), (CharSequence)intPreBill.getString("operatetype")) || EmptyUtil.isEmpty((DynamicObject)(depositBill = TmcDataServiceHelper.loadSingleFromCache((Object)(depositBillId = intPreBill.getLong("sourcebillid")), (String)"cim_deposit", (String)"intdate,endpreinstdate")))) continue;
            Date lastPayIntDate = depositBill.getDate("endpreinstdate");
            if (EmptyUtil.isNoEmpty((Object)lastPayIntDate)) {
                if (intPreBill.getDate("prestenddate").compareTo(lastPayIntDate) > 0) continue;
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u9884\u63d0\u7ed3\u675f\u65e5\u8981\u5927\u4e8e\u5b58\u6b3e\u5355\u4e0a\u6b21\u9884\u63d0\u7ed3\u675f\u65e5\u3002", (String)"DepositIntPreAuditValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
                continue;
            }
            Date intDate = depositBill.getDate("intdate");
            if (intPreBill.getDate("prestenddate").compareTo(intDate) >= 0) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u9884\u63d0\u7ed3\u675f\u65e5\u8981\u5927\u4e8e\u6216\u7b49\u4e8e\u5b58\u6b3e\u8d77\u606f\u65e5\u3002", (String)"DepositIntPreAuditValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

