/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cim.common.enums.WriteOffStatusEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositIntPreUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcebillid");
        selector.add("id");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            DynamicObject intPreBill = extData.getDataEntity();
            long depositBillId = intPreBill.getLong("sourcebillid");
            QFilter qFilter = new QFilter("sourcebillid", "=", (Object)depositBillId);
            qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            qFilter.and("writeoffstatus", "=", (Object)WriteOffStatusEnum.NO_WRITEOFF.getValue());
            qFilter.and("operatetype", "=", (Object)PreIntOperateTypeEnum.PREINT.getValue());
            DynamicObjectCollection intPreBillCols = QueryServiceHelper.query((String)intPreBill.getDataEntityType().getName(), (String)"id", (QFilter[])qFilter.toArray(), (String)"prestenddate desc");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)intPreBillCols) || intPreBill.getLong("id") == Long.parseLong(((DynamicObject)intPreBillCols.get(0)).get("id").toString())) continue;
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u4e0d\u662f\u6700\u540e\u4e00\u7b14\u9884\u63d0\u5904\u7406\u5355\uff0c\u8bf7\u6309\u7167\u65f6\u95f4\u987a\u5e8f\u53cd\u5ba1\u6838\u3002", (String)"DepositIntPreUnAuditValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

