/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.enums.DepositApplyStatusEnum;
import kd.tmc.cim.common.enums.DepositApplyTypeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositRegistValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("applystatus");
        selector.add("applytype");
        selector.add("lastamount");
        selector.add("expiredate");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extendData : dataEntity) {
            Object[] targetBillIds;
            Date expireDate;
            String applyType;
            DynamicObject depositApply = extendData.getDataEntity();
            String applyStatus = depositApply.getString("applystatus");
            if (DepositApplyStatusEnum.HANDLED.getValue().equals(applyStatus)) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5df2\u5168\u90e8\u529e\u7406\u7684\u5b58\u6b3e\u7533\u8bf7\u4e0d\u5141\u8bb8\u5b58\u6b3e\u767b\u8bb0\u3002", (String)"DepositRegistValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (DepositApplyStatusEnum.CHARGEBACK.getValue().equals(applyStatus)) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5df2\u9000\u5355\u7684\u5b58\u6b3e\u7533\u8bf7\u4e0d\u5141\u8bb8\u5b58\u6b3e\u767b\u8bb0\u3002", (String)"DepositRegistValidator_5", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (!DepositApplyTypeEnum.isDeposit((String)(applyType = depositApply.getString("applytype"))) && !DepositApplyTypeEnum.isAgree((String)applyType)) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u53ea\u6709\u5b58\u6b3e\u7533\u8bf7\u6216\u534f\u5b9a\u5b58\u6b3e\u534f\u8bae\u5141\u8bb8\u8fdb\u884c\u5b58\u6b3e\u767b\u8bb0\u3002", (String)"DepositRegistValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((Object)(expireDate = depositApply.getDate("expiredate"))) && DateUtils.truncateDate((Date)new Date()).after(expireDate)) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5f53\u524d\u65e5\u671f\u5df2\u8d85\u8fc7\u5230\u671f\u65e5\u671f\uff0c\u4e0d\u5141\u8bb8\u5b58\u6b3e\u767b\u8bb0\u3002", (String)"DepositRegistValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (!DepositApplyTypeEnum.isAgree((String)depositApply.getString("applytype")) || !EmptyUtil.isNoEmpty((Object[])(targetBillIds = TmcBotpHelper.getTargetBillIds((String)"cim_deposit_apply", (Object)depositApply.getPkValue(), (String)"cim_agreement_deposit")))) continue;
            this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u3002", (String)"DepositRegistValidator_6", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

