/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class DepositReleaseAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("finbillno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        this.validateExistsRedepositBill(Arrays.stream(dataEntities).collect(Collectors.toList()));
    }

    private List<ExtendedDataEntity> validateExistsRedepositBill(List<ExtendedDataEntity> dataEntities) {
        if (dataEntities.isEmpty()) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(1);
        List depositBillNos = dataEntities.stream().map(d -> d.getDataEntity().getString("finbillno.number")).collect(Collectors.toList());
        Map map = DepositHelper.isExistsRedepositBill(depositBillNos);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String depositBillNo = dataEntity.getDataEntity().getString("finbillno.number");
            Boolean isTrue = (Boolean)map.get(depositBillNo);
            if (isTrue != null && isTrue.booleanValue()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u5b58\u6b3e\u5355\u5b58\u5728\u5728\u9014\u7684\u7eed\u5b58\u5355\uff0c\u8bf7\u5c06\u7eed\u5b58\u5355\u5220\u9664\u540e\u518d\u64cd\u4f5c\u3002", (String)"DepositReleaseSubmitValidator_11", (String)"tmc-cim-business", (Object[])new Object[0]));
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }
}

