/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.BebankStatusEnum;
import kd.tmc.cim.common.enums.ReleaseTypeEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.BusinessHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositReleaseUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        selector.add("finbillno");
        selector.add("tradechannel");
        selector.add("bebankstatus");
        selector.add("isresubmit");
        selector.add("releasetype");
        selector.add("isautodraw");
        selector.add("accepttransfer");
        selector.add("isinit");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        List<ExtendedDataEntity> dataEntities = new ArrayList<ExtendedDataEntity>(dataEntity.length);
        for (ExtendedDataEntity extendData : dataEntity) {
            DynamicObject releaseBill = extendData.getDataEntity();
            String beBankStat = releaseBill.getString("bebankstatus");
            if (EmptyUtil.isNoEmpty((String)beBankStat) && !BebankStatusEnum.TF.getValue().equals(beBankStat)) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5df2\u7ecf\u63d0\u4ea4\u94f6\u4f01\u76f4\u8054\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"DepositReleaseUnAuditValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
                continue;
            }
            if (releaseBill.getBoolean("isresubmit")) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u5df2\u5931\u8d25\u91cd\u63d0\u7684\u89e3\u6d3b\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"DepositReleaseUnAuditValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
                continue;
            }
            Map opMap = this.getOption().getVariables();
            if (EmptyUtil.isEmpty((String)((String)opMap.get("fromApplyCancel"))) && TradeChannelEnum.ONLINE.getValue().equals(releaseBill.getString("tradechannel")) && ReleaseTypeEnum.isAgreeon((String)releaseBill.getString("releasetype")) && releaseBill.getBoolean("isautodraw")) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u4ea4\u6613\u6e20\u9053\u4e3a\u94f6\u4f01\u76f4\u8054&\u89e3\u6d3b\u7c7b\u578b\u4e3a\u7ea6\u5b9a\u89e3\u6d3b&\u81ea\u52a8\u652f\u53d6\u4e3a\u662f\u7684\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"DepositReleaseUnAuditValidator_5", (String)"tmc-cim-business", (Object[])new Object[0]));
                continue;
            }
            if (releaseBill.getBoolean("isinit") && EmptyUtil.isEmpty((String)((String)opMap.get("pass_isinit_validate")))) {
                this.addErrorMessage(extendData, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u751f\u6210\u7684\u89e3\u6d3b\u5355\uff0c\u53ea\u80fd\u5728\u5b58\u6b3e\u521d\u59cb\u5316\u5355\u64cd\u4f5c\u53cd\u5ba1\u6838\u3002", (String)"DepositReleaseUnAuditValidator_6", (String)"tmc-cim-business", (Object[])new Object[0]));
                continue;
            }
            dataEntities.add(extendData);
        }
        dataEntities = this.validateIsLastRelease(dataEntities);
        dataEntities = this.checkDirtTargetBills(dataEntities);
    }

    private List<ExtendedDataEntity> checkDirtTargetBills(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        DynamicObject releaseBill = dataEntities.get(0).getDataEntity();
        HashSet<String> excludeEntityNames = new HashSet<String>(Arrays.asList("ifm_transhandlebill", "ifm_rectransbill"));
        String releaseBillName = releaseBill.getDynamicObjectType().getName();
        excludeEntityNames.add(releaseBillName.startsWith("cim") ? "cim_dptrevenue" : "ifm_dptrevenue");
        if (releaseBill.getBoolean("accepttransfer")) {
            excludeEntityNames.add("cim_deposit");
        }
        List billIds = dataEntities.stream().map(d -> d.getDataEntity().getLong("id")).collect(Collectors.toList());
        Map msgMap = BusinessHelper.checkDirtTargetBills((String)releaseBill.getDataEntityType().getName(), billIds, excludeEntityNames, null);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long billId = dataEntity.getDataEntity().getLong("id");
            String msg = (String)msgMap.get(billId);
            if (EmptyUtil.isNoEmpty((String)msg)) {
                this.addErrorMessage(dataEntity, msg);
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }

    private List<ExtendedDataEntity> validateIsLastRelease(List<ExtendedDataEntity> dataEntities) {
        if (EmptyUtil.isEmpty(dataEntities)) {
            return dataEntities;
        }
        Set depositIds = dataEntities.stream().filter(d -> EmptyUtil.isNoEmpty((DynamicObject)d.getDataEntity().getDynamicObject("finbillno"))).map(d -> d.getDataEntity().getLong("finbillno.id")).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(depositIds)) {
            return dataEntities;
        }
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(dataEntities.size());
        DynamicObjectCollection releaseBills = QueryServiceHelper.query((String)"cim_release", (String)"id,finbillno,redeemdate,createtime", (QFilter[])new QFilter("finbillno", "in", depositIds).toArray());
        Map<Long, List<DynamicObject>> groupMap = releaseBills.stream().collect(Collectors.groupingBy(r -> r.getLong("finbillno")));
        if (groupMap.isEmpty()) {
            return dataEntities;
        }
        HashMap<Long, DynamicObject> lastReleaseMap = new HashMap<Long, DynamicObject>(releaseBills.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : groupMap.entrySet()) {
            List<DynamicObject> redeemList = entry.getValue();
            DynamicObject latestRedeem = null;
            for (DynamicObject redeem : redeemList) {
                if (null == latestRedeem) {
                    latestRedeem = redeem;
                    continue;
                }
                if (latestRedeem.getDate("redeemdate").compareTo(redeem.getDate("redeemdate")) < 0) {
                    latestRedeem = redeem;
                    continue;
                }
                if (latestRedeem.getDate("redeemdate").compareTo(redeem.getDate("redeemdate")) != 0 || latestRedeem.getDate("createtime").compareTo(redeem.getDate("createtime")) >= 0) continue;
                latestRedeem = redeem;
            }
            lastReleaseMap.put(entry.getKey(), latestRedeem);
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject releaseBill = dataEntity.getDataEntity();
            long depositId = releaseBill.getLong("finbillno.id");
            DynamicObject lastReleaseBill = (DynamicObject)lastReleaseMap.get(depositId);
            if (lastReleaseBill != null && lastReleaseBill.getLong("id") != releaseBill.getLong("id")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u89e3\u6d3b\u5355\u4e0d\u662f\u6700\u540e\u4e00\u5f20\u89e3\u6d3b\u5355\uff0c\u8bf7\u6839\u636e\u751f\u6210\u7684\u987a\u5e8f\u5012\u5e8f\u53cd\u5ba1\u6838\u3002", (String)"DepositReleaseUnAuditValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
                continue;
            }
            dataEntityList.add(dataEntity);
        }
        return dataEntityList;
    }
}

