/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.validate.deposit;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.DepositApplyTypeEnum;
import kd.tmc.cim.common.enums.ExpireRedepositTypeEnum;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FixedDepositAutoReleaseValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("billstatus");
        selector.add("bizstatus");
        selector.add("expiredate");
        selector.add("investvarieties");
        selector.add("finorginfo");
        selector.add("billno");
        selector.add("expireredeposit");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity extData : dataEntity) {
            String investType;
            DynamicObject deposit = extData.getDataEntity();
            String billStatus = deposit.getString("billstatus");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u9700\u662f\u5df2\u5ba1\u6838\u7684\u3002", (String)"DepositDealAutoRevenueValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            String bizStatus = deposit.getString("bizstatus");
            if (!FinServiceStatusEnum.subscribe_done.getValue().equals(bizStatus) && !FinServiceStatusEnum.subscribe_part.getValue().equals(bizStatus)) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5b58\u6b3e\u4e1a\u52a1\u72b6\u6001\u5e94\u4e3a\u5df2\u5b58\u6b3e\u6216\u5df2\u90e8\u5206\u89e3\u6d3b\u3002", (String)"DepositDealAutoRevenueValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            String expireRedeposit = deposit.getString("expireredeposit");
            if (!ExpireRedepositTypeEnum.NOREDEPOSIT.getValue().equals(expireRedeposit)) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u5230\u671f\u662f\u5426\u7eed\u5b58\u9700\u662f\u4e0d\u7eed\u5b58\u7684\u3002", (String)"DepositDealAutoReleaseValidator_7", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            Date expireDate = deposit.getDate("expiredate");
            Date currentDate = DateUtils.getCurrentDate();
            if (EmptyUtil.isNoEmpty((Object)expireDate) && expireDate.compareTo(currentDate) != 0) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u89e3\u6d3b\u5931\u8d25\uff0c\u53ea\u6709\u201c\u5230\u671f\u65e5\u671f\u201d\u7b49\u4e8e\u4eca\u65e5\u7684\u5b58\u6b3e\u5355\u624d\u80fd\u81ea\u52a8\u89e3\u6d3b\u3002", (String)"DepositDealAutoReleaseValidator_1", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (!InvestTypeEnum.isFixed((String)(investType = Optional.ofNullable(deposit.getDynamicObject("investvarieties")).map(r -> r.getString("investtype")).orElse("")))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u89e3\u6d3b\u5931\u8d25\uff0c\u53ea\u6709\u5b9a\u671f\u5b58\u6b3e\u5355\u624d\u80fd\u81ea\u52a8\u89e3\u6d3b\u3002", (String)"DepositDealAutoReleaseValidator_2", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            if (DepositHelper.isExistsRedepositBill((String)deposit.getString("billno"))) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u89e3\u6d3b\u5931\u8d25\uff0c\u8be5\u5b58\u6b3e\u5355\u5b58\u5728\u5728\u9014\u7684\u7eed\u5b58\u5355\u3002", (String)"DepositDealAutoReleaseValidator_5", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            QFilter applyQfilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
            applyQfilter.and(new QFilter("applytype", "=", (Object)DepositApplyTypeEnum.SUBSIST.getValue()));
            applyQfilter.and(new QFilter("deposit", "=", deposit.getPkValue()));
            boolean exists = QueryServiceHelper.exists((String)"cim_deposit_apply", (QFilter[])new QFilter[]{applyQfilter});
            if (exists) {
                this.addErrorMessage(extData, ResManager.loadKDString((String)"\u89e3\u6d3b\u5931\u8d25\uff0c\u8be5\u5b58\u6b3e\u5355\u5b58\u5728\u5728\u9014\u7684\u7eed\u5b58\u7533\u8bf7\u5355\u3002", (String)"DepositDealAutoReleaseValidator_6", (String)"tmc-cim-business", (Object[])new Object[0]));
            }
            this.validateByCurrentEntity(extData, deposit);
        }
    }

    private void validateByCurrentEntity(ExtendedDataEntity extData, DynamicObject deposit) {
        String entityName = deposit.getDynamicObjectType().getName();
        if ("cim_deposit".equals(entityName) && DepositHelper.isSettleCenterBill((DynamicObject)deposit)) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u6570\u636e\uff0c\u6b64\u5904\u4e0d\u5141\u8bb8\u4f5c\u81ea\u52a8\u89e3\u6d3b\u3002", (String)"DepositDealAutoReleaseValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]));
        } else if ("ifm_deposit".equals(entityName) && !DepositHelper.isSettleCenterBill((DynamicObject)deposit)) {
            this.addErrorMessage(extData, ResManager.loadKDString((String)"\u975e\u7ed3\u7b97\u4e2d\u5fc3\u6570\u636e\uff0c\u6b64\u5904\u4e0d\u5141\u8bb8\u4f5c\u81ea\u52a8\u89e3\u6d3b\u3002", (String)"DepositDealAutoReleaseValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }
}

